package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigDecimal;

import lombok.Data;

/**
 * 广告素材配置用户出价.</br>
 * Created by zhengwangeng on 2021/11/25
 */
@Data
public class AssetsConfigUid implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 设备号类型
     */
    private String deviceType;

    /**
     * 用户设备号标识
     */
    private String uid;

    /**
     * 券ID
     */
    private String ticketId;

    /**
     * 素材ID
     */
    private String assetsId;

    /**
     * 出价CPM，单位：元
     */
    private BigDecimal price;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;
}