package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 广告位标签地域规则
 * <pre>
 *     {tag}-{regionCode}
 * </pre>
 * @author allen
 * @date 2017-12-06
 */
public class PositionTagRegionRuleSo extends AbstractTwoRule {

    @JSONField(deserialize = false, serialize = false)
    private List<Entry> entries = Lists.newArrayList();

    @Override
    protected void addItem(int one, String two) {
        this.entries.add(new Entry(one, two));
    }

    public List<Entry> getEntries() {
        return entries;
    }

    public static class Entry {

        private int tag;
        private String regionCode;

        public Entry(int tag, String regionCode) {
            this.tag = tag;
            this.regionCode = regionCode;
        }

        public int getTag() {
            return tag;
        }

        public void setTag(int tag) {
            this.tag = tag;
        }

        public String getRegionCode() {
            return regionCode;
        }

        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }
    }
}
