package com.bxm.adsprod.facade.ticket;

import lombok.Data;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;

@Data
public class TicketExplore {

    private Long ticketId;

    /**
     * 是否开启加速探索（0 开启  1 关闭）
     */
    private Short status = 0;

    /**
     * 加速探索策略（ 0 全局  1 广告位）
     */
    private Short type;


    private LocalDate startDate;

    private LocalDate endDate;

    private LocalTime dayStartTime;

    private LocalTime dayEndTime;

    /**
     * 1全天  2 指定
     */
    private Short launchType;

    private Long budgetDaily = 2000000L;

    private String sequence;

    private Integer clickThreshold = 200;

    private List<String> sequenceList;


    public Boolean isOpen() {
        return status != null && status == 0;
    }

    public Boolean isAllPosition() {
        return type != null && type == 0;
    }

    public Boolean isAppoint() {
        return launchType != null && launchType == 2;
    }
}