package com.bxm.adsprod.facade.media.sdk;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>SDK初始化返回对象</h3>
 *
 * @author kerry.jiang
 * @date 2019/5/20 17:55
 */
public class EquipmentRedord implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /**
     * 广告位信息列表
     */
    private List<PositionInfo> positions;

    public List<PositionInfo> getPositions() {
        return positions;
    }

    public void setPositions(List<PositionInfo> positions) {
        this.positions = positions;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /**
     * 广告位信息
     */
    public static class PositionInfo implements Serializable {

        private static final long serialVersionUID = 9132608548480991005L;
        /**
         * 广告位ID
         */
        private String positionId;
        /**
         * SDK渠道列表
         */
        private List<ChannelInfo> channels;

        public String getPositionId() {
            return positionId;
        }

        public void setPositionId(String positionId) {
            this.positionId = positionId;
        }

        public List<ChannelInfo> getChannels() {
            return channels;
        }

        public void setChannels(List<ChannelInfo> channels) {
            this.channels = channels;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }


    /**
     * SDK渠道信息
     */
    public static class ChannelInfo implements Serializable {

        private static final long serialVersionUID = 9132608548480991005L;
        /**
         * 渠道
         * bxm_channel: 变现猫
         * csj_channel: 穿山甲
         * gdt_channel: 广点通
         * bd_channel: 百度
         * mobvista_channel: mobvista
         */
        private String channel;
        /**
         * 应用ID
         */
        private String appId;
        /**
         * 应用Key
         */
        private String appKey;
        /**
         * 应用广告位,sdk渠道提供的广告位
         */
        private String appPosition;
        /**
         * 视频方向：1横版，2竖板
         */
        private Byte videoDirection;
        /**
         * 排序
         */
        private Integer sort;

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public String getAppId() {
            return appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAppKey() {
            return appKey;
        }

        public void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        public String getAppPosition() {
            return appPosition;
        }

        public void setAppPosition(String appPosition) {
            this.appPosition = appPosition;
        }

        public Byte getVideoDirection() {
            return videoDirection;
        }

        public void setVideoDirection(Byte videoDirection) {
            this.videoDirection = videoDirection;
        }

        public Integer getSort() {
            return sort;
        }

        public void setSort(Integer sort) {
            this.sort = sort;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}
