package com.bxm.adsprod.model.so.rules;

import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Sets;

/**
 * <p>
 *     广告券已安装包名黑白名单规则
 * </p>
 * <pre>
 *     {type}-{packageName},{packageName},{packageName}
 *
 *     type=类型。1- 白名单、2- 黑名单
 *     packageName=已安装包名
 * </pre>
 *
 * @author kerry.jiang
 * @date 2020/11/12 10:49
 */
public class TicketAppPackageRuleSo extends RuleSo {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketAppPackageRuleSo.class);

    public static final String TYPE_WHITELIST = "1";
    public static final String TYPE_BLACKLIST = "2";

    private static final int VALUE_SPLIT_SIZE = 2;

    /**
     * 是否为黑名单
     */
    @JSONField(deserialize = false, serialize = false)
    private boolean blackList;
    /**
     * 已安装包名
     */
    @JSONField(deserialize = false, serialize = false)
    private Set<String> packageNames = Sets.newHashSet();

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();
        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] strings = StringUtils.split(value, '-');
        if (strings.length < VALUE_SPLIT_SIZE) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Invalid value format of 'TicketAppPackageRuleSo', {}.", value);
            }
            return;
        }
        if (strings.length > VALUE_SPLIT_SIZE) {
            int startIndex = value.indexOf('-');
            strings = new String[2];
            strings[0] = StringUtils.substring(value, 0, startIndex);
            strings[1] = StringUtils.substring(value, startIndex + 1, value.length());
        }

        String type = strings[0];
        String pkns = strings[1];

        this.blackList = (StringUtils.equals(TYPE_BLACKLIST, type));
        String[] pknArray = StringUtils.split(pkns, ',');

        for (String s : pknArray) {
            this.packageNames.add(s);
        }
    }

    public boolean isBlackList() {
        return blackList;
    }

    public Set<String> getPackageNames() {
        return packageNames;
    }
}
