package com.bxm.adsprod.facade.award;

import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * 抽奖数据传输对象
 *
 * @ClassName AwardDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/20 18:15
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/20 18:15
 **/
public class AwardDto implements Serializable{
    private static final long serialVersionUID = 2955004102853948797L;

    /**
     * spm
     */
    private String spm;

    /**
     *  弹窗类型  0-出券弹窗 1-首页弹窗 2-挽留弹窗
     */
    @DefaultValue("0")
    @ValidateNotNull
    private Integer scene;

    /**
     * 媒体
     */
    private String appkey;

    /**
     * 渠道
     */
    private String business;

    /**
     * 渠道
     */
    @DefaultValue("1")
    @ValidateNotNull
    @Deprecated
    private Integer appEntrance;

    /**
     * 用户ID
     */
    @DefaultValue("mistake_uid")
    @ValidateNotNull
    private String uid;

    /**
     * IMEI 安卓唯一标识码
     */
    @ValidateImeiOrIdfa
    private String i;

    /**
     * IDFA 苹果唯一标识符
     */
    @ValidateImeiOrIdfa
    private String f;

    /**
     * 活动ID
     */
    @DefaultValue("0")
    @ValidateNotNull
    private Integer activityid;

    /**
     * 设备类型（1-安卓 2-ios 3-web）
     */
    @DefaultValue("1")
    @ValidateNotNull
    private String appos;

    /**
     * 是否是微信（1是0否）
     */
    @DefaultValue("0")
    @ValidateNotNull
    private Integer ua;

    /**
     * 是否为小程序端（1是0否）
     */
    @DefaultValue("0")
    @ValidateNotNull
    private String device;

    /**
     * 请求ip地址
     */
    private String ipaddress;

    /**
     * 是否需要考虑素材
     * js/api 需要考虑素材
     * h5  不需要素材素材
     */
    private boolean needMaterials;

    /**
     * 是否为特殊活动（如卡包（0不是，1是））
     */
    private String isSpecial = "0" ;
    /**
     * ADX券ID
     */
    private BigInteger adxTicketId;

    /**
     * 浏览器相关
     */
    private String userAgent;

    /**
     * 页面来源
     */
    private String referer;

    /**
     * 屏幕分辨率
     */
    private String random3;

    /**
     * 设备加密后的参数
     * @see #xdevice
     */
    @Deprecated
    private String did;

    /**
     * 加密后的设备信息
     */
    private String xdevice;

    /**
     * 出券类型, 1: 不出视频素材(默认)，2：只出视频素材
     */
    private Integer outType = 1;

    /**
     * 特殊定制的券id，只能在某些广告位的活动上出
     */
    private String needTicketId;
    /**
     * 不能出的券id
     */
    private String notNeedTicketId;

    /**
     * 百度的appId
     */
    private  String appId;

    /**
     * 用户行为相关（百度的特征）
     */
    private  String ed;

    /**
     * isadx 判断是否ADX流量
     * ea 是入口广告ID
     */
    private  String ea;

    private  String isadx;

    /**
     * 是否支持下载类广告，1 表示支持，其他均视为不支持。
     */
    private String idl;

    /**
     * 包名
     */
    private String bundle;

    /**
     * rtb扩展参数
     */
    private String rtb_ext;
    /**
     * 头部券算法code
     */
    private String heaAlgoCode;


    /**
     * 手机号
     */
    private String phone;
    /**
     * 本次请求指定出符合这些标签的广告券
     */
    private String tags;

    /**
     * 本次请求排除符合这些标签的广告券
     */
    private String excludeTags;

    /**
     * 上一次bxmId
     */
    private String tencent_reqid;
    /**
     * 行业中建议配置ID
     */
    private String tencent_suk;

    /**
     * 行业中间页上一次请求的券ID
     */
    private String tencent_id;

    /**
     * 行业中间页上一次请求的自建站产品ID
     */
    private String tencent_lp_id;

    public String getTencent_lp_id() {
        return tencent_lp_id;
    }

    public void setTencent_lp_id(String tencent_lp_id) {
        this.tencent_lp_id = tencent_lp_id;
    }

    public String getTencent_id() {
        return tencent_id;
    }

    public void setTencent_id(String tencent_id) {
        this.tencent_id = tencent_id;
    }

    public String getTencent_reqid() {
        return tencent_reqid;
    }

    public void setTencent_reqid(String tencent_reqid) {
        this.tencent_reqid = tencent_reqid;
    }

    public String getTencent_suk() {
        return tencent_suk;
    }

    public void setTencent_suk(String tencent_suk) {
        this.tencent_suk = tencent_suk;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public boolean isWeixin() {
        return ua != null && ua == 1;
    }

    public String getPositionId() {
        String id = business;
        if (null != business) {
            id = business.replaceAll("ad-|money-", "");
        }
        return StringUtils.join(new Object []{appkey, id}, "-");
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public Integer getAppEntrance() {
        return appEntrance;
    }

    public void setAppEntrance(Integer appEntrance) {
        this.appEntrance = appEntrance;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getIsSpecial() {
        if(StringUtils.isBlank(isSpecial)){
            return "0";
        }
        return isSpecial;
    }

    public void setIsSpecial(String isSpecial) {
        this.isSpecial = isSpecial;
    }

    public String getI() {
        return i;
    }

    public void setI(String i) {
        this.i = i;
    }

    public String getF() {
        return f;
    }

    public void setF(String f) {
        this.f = f;
    }

    public Integer getActivityid() {
        return activityid;
    }

    public void setActivityid(Integer activityid) {
        this.activityid = activityid;
    }

    public String getAppos() {
        return appos;
    }

    public void setAppos(String appos) {
        this.appos = appos;
    }

    public Integer getUa() {
        return ua;
    }

    public void setUa(Integer ua) {
        this.ua = ua;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public boolean isNeedMaterials() {
        return needMaterials;
    }

    public void setNeedMaterials(boolean needMaterials) {
        this.needMaterials = needMaterials;
    }

    public BigInteger getAdxTicketId() {
        return adxTicketId;
    }

    public void setAdxTicketId(BigInteger adxTicketId) {
        this.adxTicketId = adxTicketId;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getSpm() {
        return spm;
    }

    public void setSpm(String spm) {
        this.spm = spm;
    }

    public String getRandom3() {
        return random3;
    }

    public void setRandom3(String random3) {
        this.random3 = random3;
    }

    @Deprecated
    public String getDid() {
        return did;
    }

    @Deprecated
    public void setDid(String did) {
        this.did = did;
    }

    public Integer getOutType() {
        return outType;
    }

    public void setOutType(Integer outType) {
        this.outType = outType;
    }

    public String getNeedTicketId() {
        return needTicketId;
    }

    public void setNeedTicketId(String needTicketId) {
        this.needTicketId = needTicketId;
    }

    public String getAppId() {
        return appId;
    }

    public String getNotNeedTicketId() {
        return notNeedTicketId;
    }

    public void setNotNeedTicketId(String notNeedTicketId) {
        this.notNeedTicketId = notNeedTicketId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getEd() {
        return ed;
    }

    public String getEa() {
        return ea;
    }

    public void setEa(String ea) {
        this.ea = ea;
    }

    public String getIsadx() {
        return isadx;
    }

    public void setIsadx(String isadx) {
        this.isadx = isadx;
    }

    public void setEd(String ed) {
        this.ed = ed;
    }

    public String getXdevice() {
        return xdevice;
    }

    public void setXdevice(String xdevice) {
        this.xdevice = xdevice;
    }

    public String getIdl() {
        return idl;
    }

    public String getBundle() {
        return bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setIdl(String idl) {
        this.idl = idl;
    }

    public String getRtb_ext() {
        return rtb_ext;
    }

    public void setRtb_ext(String rtb_ext) {
        this.rtb_ext = rtb_ext;
    }

    public String getHeaAlgoCode() {
        return heaAlgoCode;
    }

    public void setHeaAlgoCode(String heaAlgoCode) {
        this.heaAlgoCode = heaAlgoCode;
    }

    public String getExcludeTags() {
        return excludeTags;
    }

    public void setExcludeTags(String excludeTags) {
        this.excludeTags = excludeTags;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
