package com.bxm.adsprod.facade.award;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import org.springframework.util.StringUtils;

/**
 * 发财树返回数据字段
 */
@Data
public class WealthTree {

    private String phone;

    private String ispCode;
    private String reginCode;


    @AllArgsConstructor
    @Getter
    public enum WealthTreeEnum {
        //移动
        ISP_MOBILE("100025", "ISP-CMCC"),
        //电信
        ISP_TELECOM("100017", "ISP-LT"),
        //联通
        ISP_CHINA("100026", "ISP-DX");;
        private String name;

        private String desc;

        public static WealthTreeEnum findDescByName(String name) {
            for (WealthTreeEnum r : values()) {
                if (StringUtils.endsWithIgnoreCase(name, r.name)) {
                    return r;
                }
            }
            return null;
        }
    }

}
