package com.bxm.adsprod.model.constant;

public enum LandChannel {
    HEINIU(1, "heiniu", "黑牛保险"),
    WANGZHUAN(2, "wangzhuan", "网赚")
    ;
    private Integer id;
    private String channel;
    private String desc;

    LandChannel(Integer id, String channel, String desc) {
        this.id = id;
        this.channel = channel;
        this.desc = desc;
    }

    public static LandChannel getLandChannel(String channel){
        for(LandChannel c : LandChannel.values()){
            if(c.getChannel().equals(channel)){
                return c;
            }
        }
        return LandChannel.HEINIU;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
