package com.bxm.adsprod.facade.media;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * DSP广告位信息<br/>
 *
 * @author kerry.jiang
 * @date 2019/11/5 13:37
 */
public class OuterDspPosition implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 支持的系统
     * 0：通用
     * 1：安卓
     * 2：IOS
     */
    private Byte os;
    /**
     * 外部应用ID（第三方）
     */
    private String outer_appid;
    /**
     * 外部应用Key（第三方）
     */
    private String outer_appkey;
    /**
     * 外部应用密钥（第三方）
     */
    private String outer_appsecret;
    /**
     * 外部广告位（第三方）
     */
    private String outer_posid;
    /**
     * 包名
     * package（安卓）
     * BundleID（IOS）
     */
    private String package_name;

    public Byte getOs() {
        return os;
    }

    public void setOs(Byte os) {
        this.os = os;
    }

    public String getOuter_appid() {
        return outer_appid;
    }

    public String getOuter_appkey() {
        return outer_appkey;
    }

    public void setOuter_appkey(String outer_appkey) {
        this.outer_appkey = outer_appkey;
    }

    public String getOuter_appsecret() {
        return outer_appsecret;
    }

    public void setOuter_appsecret(String outer_appsecret) {
        this.outer_appsecret = outer_appsecret;
    }

    public void setOuter_appid(String outer_appid) {
        this.outer_appid = outer_appid;
    }

    public String getOuter_posid() {
        return outer_posid;
    }

    public void setOuter_posid(String outer_posid) {
        this.outer_posid = outer_posid;
    }

    public String getPackage_name() {
        return package_name;
    }

    public void setPackage_name(String package_name) {
        this.package_name = package_name;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}