package com.bxm.adsprod.facade.ticket;

import lombok.Data;

import java.io.Serializable;
import java.util.*;

@Data
public class PositionWhiteTicket implements Serializable {

    private static final long serialVersionUID = 9132608540991005L;

    /**
     * 投放形式 1活动 2 直投
     */
    public static final Short ACT_PUT_IN = 1;
    public static final Short DIRECT_PUT_IN = 2;


    /**
     * 兜底类型 1券 2 活动
     */
    public static final String DEFAULT_TICKET = "1";
    public static final String DEFAULT_ACT = "2";

    private String positionId;

    /**
     * 1互动 2 直投
     */
    private Short putInType;

    private Set<String> ticketIdsSet = new HashSet<>();

    private List<String> groupIdsList = new ArrayList<>();

    /**
     * 直投形式下的兜底 1 兜底券 2 兜底活动
     */
    private String defaultType;

    private Set<String> defaultTicketIdsSet = new HashSet<>();

    private List<String> defaultGroupIdsList = new ArrayList<>();

    public boolean directPutIn() {
        return putInType != null && Objects.equals(putInType, DIRECT_PUT_IN);
    }

    public boolean directDefaultBottomTypeIsTicket() {
        return defaultType != null && Objects.equals(defaultType, DEFAULT_TICKET);
    }
}