package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * 礼券arpu 值服务
 *
 * @ClassName TicketArpuService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/5/28 16:49
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/5/28 16:49
 **/
@FeignClient(name = AdsprodFacadeConstants.WEIGHT_NAME)
public interface TicketArpuService {
    /**
     * 根据广告位和礼券id获取礼券的arpu值
     *
     * @param ticketId 礼券ID
     * @param positionId 广告位ID
     * @return java.math.BigDecimal
     * @throws
     * @author kk.xie
     * @date 2018/5/28 16:52
     */
    @RequestMapping("/ticketArpuService/getTicketArpu")
    BigDecimal getTicketArpu(@RequestParam("ticketId") BigInteger ticketId,
                             @RequestParam("positionId") String positionId);
}
