package com.bxm.adsprod.model.so.rules;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

/**
 * 抽象的两个元素组成的规则
 * <pre>
 *     {onw}-{two}
 * </pre>
 * @author allen
 * @date 2017-12-06
 */
public abstract class AbstractTwoRule extends RuleSo {

    /**
     * 添加分组值
     * @param one
     * @param two
     */
    protected abstract void addItem(int one, String two);

    protected void addItem(String one, String two) {}

    /**
     * 首个参数是否为Int类型 默认true
     * @return
     */
    protected boolean isFirstInt() {return true;}

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();

        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] items = StringUtils.split(value, ',');
        for (String item : items) {
            String[] entry = StringUtils.split(item, '-');
            if (null == entry || entry.length != 2) {
                continue;
            }
            if (isFirstInt()) {
                int one = NumberUtils.toInt(entry[0], -1);
                addItem(one, entry[1]);
            } else {
                addItem(entry[0], entry[1]);
            }
        }
    }
}
