package com.bxm.adsprod.model.so.rules;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

import java.util.Arrays;

/**
 * 分隔字符串6
 */
public abstract class AbstractSixRule extends RuleSo{

    /**
     * 添加分组值
     *
     * @param one
     * @param two
     * @param three
     * @param four
     */
    protected abstract void addItem(String one, String two, String three,String four, String five, String six);

    protected char itemsSeparatorChar() {
        return ',';
    }

    protected char itemSeparatorChar() {
        return '-';
    }

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();

        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] items = StringUtils.split(value, itemsSeparatorChar());
        for (String item : items) {
            String[] entry = StringUtils.split(item, itemSeparatorChar());
            if (null == entry || entry.length > 6) {
                continue;
            }
            // 因为存在有老数据<6的情况
            if (entry.length < 6) {
                entry = fillDefaultValue(entry);
            }
            addItem(entry[0], entry[1], entry[2],entry[3], entry[4], entry[5]);
        }
    }


    /**
     * 数组补默认值  到6位
     * @param entry
     * @return
     */
    private String[] fillDefaultValue(String[] entry) {
        int gap = 6 - entry.length;
        if (gap > 0) {
            for (int i = 0; i < gap; i++) {
                entry = ArrayUtils.add(entry, "null");
            }
        }
        return entry;
    }


}
