package com.bxm.adsprod.facade.award;

import com.bxm.adsprod.facade.ticket.DownloadLandingPage;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

/**
 * 奖品信息封装
 *
 * @ClassName Award
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/23 18:15
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/23 18:15
 **/
public class Award implements Serializable{
	private static final long serialVersionUID = 1936807165088551325L;
	
	public static final int LANDING_TYPE_DEFAULT = 0;
	public static final int LANDING_TYPE_MICROAPP = 1;

	/**
	 * 奖品名称
	 */
	private String awardname;

	/**
	 * 奖品图片
	 */
	private String awardimg;

	/**
	 * 素材介绍
	 */
	private String awardmsg;

	/**
	 * 奖品ID
	 */
	private Long awardid;

	/**
	 * 奖品链接
	 */
	private String awardlink;

	/**
	 * deeplink跳转地址
	 */
	private String deeplinkUrl;

	/**
	 * 落地页类型，1-下载类，2-表单类，3-deeplink表单类，4-deeplink下载类
	 */
	private Short pageType;

	/**
	 * 奖品类型 1-奖品 2-礼券
	 */
	private Integer awardtype;

	/**
	 * 按钮名称
	 */
	private String buttontext;

	/**
	 * 有效期
	 */
	private String validitytime;

	/**
	 * 抽奖记录的数据库ID
	 */
	private Long awardorderid;

	/**
	 * 当前活动是否可以继续
	 */
	private Boolean iscontinue;

	/**
	 * 礼券的行业类型
	 */
	private Integer shopstype;

	/**
	 * 大转盘的固定旋转角度 300
	 */
	private String awardangle = "300";

	/**
	 * 抽到奖品--奖品流水号，抽到礼券--null
	 */
	private String ordernum;

	/**
	 * 废弃状态 TODO
	 */
	private Integer state;

	/**
	 * 素材ID
	 */
	private Long assetsId;

	/**
	 * 0= 普通落地页、1= 小程序
	 */
	private int landingType = 0;
	
	/**
	 * 首张弹窗
	 */
	private PopupVo firstPopup;

	/**
	 * 挽留弹窗
	 */
	private PopupVo detainPopup;

	/**
	 * 0.横版大图600*300(默认值，原不限弹窗)
	 * 1.竖版大图（原一体化弹窗）
	 * 2.横版大图1280*720
	 * 3.竖版大图1080*1920
	 * 4.小图150*150
	 * 5.竖版大图-动画素材（动效弹窗）
	 * 6.竖版视频-720*1280
	 */
	private String isShieldPopup;

	/**
	 * 票据
	 */
	private String ticket;

	/**
	 *  bxmId
	 */
	private String bxmId;

	/**
	 * 算法名称
	 */
	private String algorithmlName;

	/**
	 * APP包名
	 */
	private String packageName;

	/**
	 * 点击监测地址
	 */
	private List<String> clktrackers;
	/**
	 * 曝光监测地址
	 */
	private List<String> imptrackers;

	/**
	 * 埋点信息（SDK）
	 */
	@Deprecated
	private AwardTracker tracker;

	/**
	 * 动效弹窗
	 */
	private PopupVo dynamicPopup;

	/**
	 * 动效图片
	 */
	private List<String> dynamicImgs;

	/**
	 * 动效内容
	 */
	private List<String> dynamicTexts;

	/**
	 * 落地页id
	 */
	private Long landId;

	/**
	 * 广告ICON
	 */
	private String icon;

	/**
	 * 视频
	 */
	private String video;

	/**
	 * banner
	 */
	private String banner;
	/**
	 * 广告内容
	 */
	private String content;

	/**
	 * 权益奖品ID
	 */
	private BigInteger rightsId;

	/**
	 * 广告&活动标签 用于直投集合页活动
	 */
	private Integer ticketActivityMatchTag;

    /**
     * 奖品发放类型 ： 0.线下发奖 1.实时现金
     */
    private Integer awardSendType;

    /**
     * 现金金额
     */
    private Double cashAmount;

    /**
     * 下载落地页信息
     */
    private DownloadLandingPage downloadLandingPage;
	/**
	 * sbid
	 * bxmid对应的映射id
	 */
	private String sbid;

	/**
	 * 券组ID，埋点用
	 */
	private String ticketGroupId;


	/**
	 * 埋点用
	 * 发券次序
	 * 是否探索出价
	 */
	private Long userBxmCount;
	private Integer exploreType;


	/**
	 * 落地页id 埋点使用
	 */
	private Long lpProductId;

	/**
	 * 用户活动发券次序
	 */
	private Long userActBxmCount;

	public DownloadLandingPage getDownloadLandingPage() {
		return downloadLandingPage;
	}

	public void setDownloadLandingPage(DownloadLandingPage downloadLandingPage) {
		this.downloadLandingPage = downloadLandingPage;
	}

	public Long getLpProductId() {
		return lpProductId;
	}

	public void setLpProductId(Long lpProductId) {
		this.lpProductId = lpProductId;
	}

	public List<String> getClktrackers() {
		return clktrackers;
	}

	public void setClktrackers(List<String> clktrackers) {
		this.clktrackers = clktrackers;
	}

	public List<String> getImptrackers() {
		return imptrackers;
	}

	public void setImptrackers(List<String> imptrackers) {
		this.imptrackers = imptrackers;
	}

	public String getIsShieldPopup() {
		return isShieldPopup;
	}

	public void setIsShieldPopup(String isShieldPopup) {
		this.isShieldPopup = isShieldPopup;
	}

	public PopupVo getFirstPopup() {
		return firstPopup;
	}

	public void setFirstPopup(PopupVo firstPopup) {
		this.firstPopup = firstPopup;
	}

	public PopupVo getDetainPopup() {
		return detainPopup;
	}

	public void setDetainPopup(PopupVo detainPopup) {
		this.detainPopup = detainPopup;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public String getOrdernum() {
		return ordernum;
	}

	public void setOrdernum(String ordernum) {
		this.ordernum = ordernum;
	}

	public String getAwardangle() {
		return awardangle;
	}

	public void setAwardangle(String awardangle) {
		this.awardangle = awardangle;
	}

	public Integer getShopstype() {
		return shopstype;
	}

	public void setShopstype(Integer shopstype) {
		this.shopstype = shopstype;
	}

	public Boolean getIscontinue() {
		return iscontinue;
	}

	public void setIscontinue(Boolean iscontinue) {
		this.iscontinue = iscontinue;
	}

	public Long getAwardorderid() {
		return awardorderid;
	}

	public void setAwardorderid(Long awardorderid) {
		this.awardorderid = awardorderid;
	}

	public String getValiditytime() {
		return validitytime;
	}

	public void setValiditytime(String validitytime) {
		this.validitytime = validitytime;
	}

	public String getButtontext() {
		return buttontext;
	}

	public void setButtontext(String buttontext) {
		this.buttontext = buttontext;
	}

	public Integer getAwardtype() {
		return awardtype;
	}
 
    public Long getAssetsId() {
        return assetsId;
    }
    public void setAssetsId(Long assetsId) {
        this.assetsId = assetsId;
    }

    public void setAwardtype(Integer awardtype) {
		this.awardtype = awardtype;
	}

	public String getAwardname() {
		return awardname;
	}

	public void setAwardname(String awardname) {
		this.awardname = awardname;
	}

	public String getAwardimg() {
		return awardimg;
	}

	public void setAwardimg(String awardimg) {
		this.awardimg = awardimg;
	}

	public String getAwardmsg() {
		return awardmsg;
	}

	public void setAwardmsg(String awardmsg) {
		this.awardmsg = awardmsg;
	}

	public Long getAwardid() {
		return awardid;
	}

	public void setAwardid(Long awardid) {
		this.awardid = awardid;
	}

	public String getAwardlink() {
		return awardlink;
	}

	public void setAwardlink(String awardlink) {
		this.awardlink = awardlink;
	}

	public String getDeeplinkUrl() {
		return deeplinkUrl;
	}

	public void setDeeplinkUrl(String deeplinkUrl) {
		this.deeplinkUrl = deeplinkUrl;
	}

	public Short getPageType() {
		return pageType;
	}

	public void setPageType(Short pageType) {
		this.pageType = pageType;
	}

	public int getLandingType() {
		return landingType;
	}

	public void setLandingType(int landingType) {
		this.landingType = landingType;
	}

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public String getBxmId() {
		return bxmId;
	}

	public void setBxmId(String bxmId) {
		this.bxmId = bxmId;
	}

	public String getAlgorithmlName() {
		return algorithmlName;
	}

	public void setAlgorithmlName(String algorithmlName) {
		this.algorithmlName = algorithmlName;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public AwardTracker getTracker() {
		return tracker;
	}

	public void setTracker(AwardTracker tracker) {
		this.tracker = tracker;
	}

	public PopupVo getDynamicPopup() {
		return dynamicPopup;
	}

	public void setDynamicPopup(PopupVo dynamicPopup) {
		this.dynamicPopup = dynamicPopup;
	}

	public List<String> getDynamicImgs() {
		return dynamicImgs;
	}

	public void setDynamicImgs(List<String> dynamicImgs) {
		this.dynamicImgs = dynamicImgs;
	}

	public List<String> getDynamicTexts() {
		return dynamicTexts;
	}

	public void setDynamicTexts(List<String> dynamicTexts) {
		this.dynamicTexts = dynamicTexts;
	}

	public Long getLandId() {
		return landId;
	}

	public void setLandId(Long landId) {
		this.landId = landId;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getVideo() {
		return video;
	}

	public void setVideo(String video) {
		this.video = video;
	}

	public String getBanner() {
		return banner;
	}

	public String getContent() {
		return content;
	}

	public BigInteger getRightsId() {
		return rightsId;
	}

	public void setRightsId(BigInteger rightsId) {
		this.rightsId = rightsId;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public Integer getTicketActivityMatchTag() {
		return ticketActivityMatchTag;
	}

	public void setTicketActivityMatchTag(Integer ticketActivityMatchTag) {
		this.ticketActivityMatchTag = ticketActivityMatchTag;
	}

	public String getSbid() {
		return sbid;
	}

	public void setSbid(String sbid) {
		this.sbid = sbid;
	}

	public void setBanner(String banner) {
		this.banner = banner;
	}

    public Integer getAwardSendType() {
        return awardSendType;
    }

    public void setAwardSendType(Integer awardSendType) {
        this.awardSendType = awardSendType;
    }

    public Double getCashAmount() {
        return cashAmount;
    }

	public String getTicketGroupId() {
		return ticketGroupId;
	}

	public Long getUserBxmCount() {
		return userBxmCount;
	}

	public void setUserBxmCount(Long userBxmCount) {
		this.userBxmCount = userBxmCount;
	}

	public Long getUserActBxmCount() {
		return userActBxmCount;
	}

	public void setUserActBxmCount(Long userActBxmCount) {
		this.userActBxmCount = userActBxmCount;
	}

	public Integer getExploreType() {
		return exploreType;
	}

	public void setExploreType(Integer exploreType) {
		this.exploreType = exploreType;
	}

	public void setTicketGroupId(String ticketGroupId) {
		this.ticketGroupId = ticketGroupId;
	}

	public void setCashAmount(Double cashAmount) {
        this.cashAmount = cashAmount;
    }
}
