package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

import lombok.Data;

/**
 * 下载类落地页
 * Created by zhengwangeng on 2021/09/06
 */
@Data
public class DownloadLandingPage implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private BigInteger id;

    /**
     * 下载地址
     */
    private String downloadUrl;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 系统类型：1-安卓，2-IOS
     */
    private Byte osType;

    /**
     * 下载安装包的IOS Id/包名
     */
    private String appPackageName;

    /**
     * 应用介绍
     */
    private String appDesc;

    /**
     * 应用大小
     */
    private BigDecimal appSize;

    /**
     * 开发者名称
     */
    private String developerName;

    /**
     * 版本号
     */
    private String version;

    /**
     * 隐私协议URL
     */
    private String privacyAgreementUrl;

    /**
     * 用户权限URL
     */
    private String userRightsUrl;

    /**
     * 试玩时长
     */
    private Integer trialTime;

    /**
     * 下载完成是否自动拉起：0否，1是
     */
    private Byte downloadDoneAutoPullUp;

    /**
     * deeplink地址
     */
    private String deeplinkUrl;

    /**
     * 应用Icon
     */
    private String appIconUrl;
}
