package com.bxm.adsprod.facade.ticket.inspirevideo;

import com.bxm.adsprod.facade.ticket.TicketInspireTracker;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * 外部激励视频<br/>
 *
 * @author kerry.jiang
 * @date 2020/10/9 14:04
 */
public class OfferInspireVideo implements Serializable {

    private static final long serialVersionUID = 1733401522239243683L;

    /**
     * 广告券ID
     */
    private BigInteger ticketId;
    /**
     * 落地页类型，1下载类，2表单类，3deeplink
     */
    private Short pageType;
    /**
     * 下载安装包的AppID/包名
     */
    private String packageName;
    /**
     * 跳转地址
     */
    private String jumpUrl;
    /**
     * deeplink跳转地址
     */
    private String deeplinkUrl;


    /**
     * 素材id
     */
    private BigInteger creativeId;
    /**
     * 视频
     */
    private String videoUrl;
    /**
     * 视频时长,秒
     */
    private Double videoDuration;
    /**
     * 视频方向(1.横版 2.竖版)
     */
    private Short videoDirection;
    /**
     * 视频的宽度，单位 px
     */
    private Integer videoWidth;
    /**
     * 视频的高度，单位 px
     */
    private Integer videoHeight;
    /**
     * 封面
     */
    private String coverUrl;
    /**
     * 标题
     */
    private String title;
    /**
     * 副标题
     */
    private String subtitle;
    /**
     * ICON
     */
    private String iconUrl;
    /**
     * 按钮内容
     */
    private String buttonContent;
    /**
     * 结束页轮播图片，多个按英文逗号分隔。允许空元素。如：url,url
     */
    private String endPagePictures;
    /**
     * 结束页地址
     */
    private String endPageUrl;
    /**
     * 监测信息
     */
    private TicketInspireTracker tracker;

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public Short getPageType() {
        return pageType;
    }

    public void setPageType(Short pageType) {
        this.pageType = pageType;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getDeeplinkUrl() {
        return deeplinkUrl;
    }

    public void setDeeplinkUrl(String deeplinkUrl) {
        this.deeplinkUrl = deeplinkUrl;
    }

    public BigInteger getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(BigInteger creativeId) {
        this.creativeId = creativeId;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public Double getVideoDuration() {
        return videoDuration;
    }

    public void setVideoDuration(Double videoDuration) {
        this.videoDuration = videoDuration;
    }

    public Short getVideoDirection() {
        return videoDirection;
    }

    public void setVideoDirection(Short videoDirection) {
        this.videoDirection = videoDirection;
    }

    public Integer getVideoWidth() {
        return videoWidth;
    }

    public void setVideoWidth(Integer videoWidth) {
        this.videoWidth = videoWidth;
    }

    public Integer getVideoHeight() {
        return videoHeight;
    }

    public void setVideoHeight(Integer videoHeight) {
        this.videoHeight = videoHeight;
    }

    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getButtonContent() {
        return buttonContent;
    }

    public void setButtonContent(String buttonContent) {
        this.buttonContent = buttonContent;
    }

    public String getEndPagePictures() {
        return endPagePictures;
    }

    public void setEndPagePictures(String endPagePictures) {
        this.endPagePictures = endPagePictures;
    }

    public String getEndPageUrl() {
        return endPageUrl;
    }

    public void setEndPageUrl(String endPageUrl) {
        this.endPageUrl = endPageUrl;
    }

    public TicketInspireTracker getTracker() {
        return tracker;
    }

    public void setTracker(TicketInspireTracker tracker) {
        this.tracker = tracker;
    }
}
