package com.bxm.adsprod.facade.media;

import java.io.Serializable;

/**
 * @author allen
 * @date 2019/7/16
 * @since 1.0.0
 */
public class PositionAdx implements Serializable {

    private static final long serialVersionUID = -1775450705547477202L;

    /**
     * 互动广告
     */
    public static final short ADTYPE_ADX_ACTIVITY = 1;
    /**
     * 直投广告
     */
    public static final short ADTYPE_ADX_DIRECT = 2;
    /**
     * ADX广告
     */
    public static final short ADTYPE_ADX = 10;

    /**
     * 原生
     */
    public static final short POSITION_TYPE_NATIVE = 1;
    /**
     * 图片
     */
    public static final short POSITION_TYPE_PICTURE = 2;
    /**
     * 视频
     */
    public static final short POSITION_TYPE_VIDEO = 3;
    /**
     * 文本
     */
    public static final short POSITION_TYPE_TEXT = 4;
    /**
     * 原生视频
     */
    public static final short POSITION_TYPE_NATIVE_VIDEO = 5;
    /**
     * 开屏
     */
    public static final short POSITION_TYPE_BOOT = 6;
    /**
     * 插屏
     */
    public static final short POSITION_TYPE_SCREEN = 7;
    /**
     * 信息流
     */
    public static final short POSITION_TYPE_INFORMATION_FLOW = 8;
    /**
     * 横幅
     */
    public static final short POSITION_TYPE_BANNERS = 9;
    /**
     * 激励视频
     */
    public static final short POSITION_TYPE_INSPIRE_VIDEO = 10;
    /**
     * 全屏视频
     */
    public static final short POSITION_TYPE_FULL_VIDEO = 11;
    /**
     * 沉浸式视频
     */
    public static final short POSITION_TYPE_IMMERSIVE_VIDEO = 12;


    public static final short SETTLE_TYPE_CPC = 1;
    public static final short SETTLE_TYPE_CPA = 2;
    public static final short SETTLE_TYPE_OCPC = 3;
    public static final short SETTLE_TYPE_CPM = 4;

    private String positionId;
    private String adType;
    private short positionType;
    private String positionTypeDesc;
    private int normalRequestsRatio;
    private short settleType;
    private Short adxChannel;
    private String channelTagId;

    /**
     * 素材模版Id,多个用逗号分隔
     */
    private String assetsTemplateId;

    /**
     * 利润率
     */
    private Integer profitMargin;

    /**
     * 广告位尺寸大小，格式为：宽-高
     * 选择场景为开屏插屏、信息流、横幅时展示必填字段“图片尺寸”，
     * 选择激励视频、全屏视频、沉浸式视频时展示必填字段“视频尺寸”
     */
    private String positionSize;

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAdType() {
        return adType;
    }

    public void setAdType(String adType) {
        this.adType = adType;
    }

    public short getPositionType() {
        return positionType;
    }

    public void setPositionType(short positionType) {
        this.positionType = positionType;
    }

    public String getPositionTypeDesc() {
        return positionTypeDesc;
    }

    public void setPositionTypeDesc(String positionTypeDesc) {
        this.positionTypeDesc = positionTypeDesc;
    }

    public int getNormalRequestsRatio() {
        return normalRequestsRatio;
    }

    public void setNormalRequestsRatio(int normalRequestsRatio) {
        this.normalRequestsRatio = normalRequestsRatio;
    }

    public short getSettleType() {
        return settleType;
    }

    public void setSettleType(short settleType) {
        this.settleType = settleType;
    }

    public Short getAdxChannel() {
        return adxChannel;
    }

    public void setAdxChannel(Short adxChannel) {
        this.adxChannel = adxChannel;
    }

    public String getChannelTagId() {
        return channelTagId;
    }

    public void setChannelTagId(String channelTagId) {
        this.channelTagId = channelTagId;
    }

    public String getAssetsTemplateId() {
        return assetsTemplateId;
    }

    public void setAssetsTemplateId(String assetsTemplateId) {
        this.assetsTemplateId = assetsTemplateId;
    }

    public Integer getProfitMargin() {
        return profitMargin;
    }

    public void setProfitMargin(Integer profitMargin) {
        this.profitMargin = profitMargin;
    }

    public String getPositionSize() {
        return positionSize;
    }

    public void setPositionSize(String positionSize) {
        this.positionSize = positionSize;
    }
}
