package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;

import lombok.Data;

@Data
public class AssetsTemplateContent implements Serializable {

    private static final long serialVersionUID = 8255898196234336477L;

    private Long id;

    /**
     * 模板ID
     */
    private Long templateId;

    /**
     * 元素类型：1文本， 2图片，3视频
     */
    private Short elementType;

    /**
     * 元素名称
     */
    private Short elementName;

    /**
     * 字数长度范围，min_len-max_len
     */
    private String textLenRange;

    /**
     * 图片约束 {width-height-maximum_kb}。width：宽，height：高，maximum_kb：最大KB限制
     */
    private String pictureConstraints;

    /**
     * 图片格式：JPG,JPEG,PNG,GIF多个以逗号分割
     */
    private String pictureFormats;

    /**
     * 视频尺寸限制。{width-height-maximum_kb-bitrate_kbps}。width：宽，height：高，maximum_kb：最大KB限制,bitrate_kbps:视频码率
     */
    private String videoConstraints;

    /**
     * 视频时长{least_len-maximum_len}。least_len：最小时长，maximum_len：最大时长
     */
    private String videoDuration;

    /**
     * 视频格式：MP4 多个以逗号分割
     */
    private String videoFormats;

    /**
     * 是否必填：0非必填，1必填
     */
    private Short required;

    /**
     * 顺序
     */
    private Short sort;

}