package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.rules.Rule;
import com.bxm.adsprod.facade.ticket.adx.TicketAdx;
import com.bxm.adsprod.facade.ticket.adx.TicketAdxCreative;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideo;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideoCreative;

import java.util.List;

/**
 * <h3>包含规则的广告券信息</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/28
 */
public class TicketOfRules extends Ticket {

    private static final long serialVersionUID = -5375015030248563075L;

    /**
     * 该广告券配置的票券码基本信息
     */
    private TicketCouponsInfo ticketCouponsInfo;
    /**
     * 该广告券配置的票券码素材列表
     */
    private List<TicketAssetsCoupons> assetsCoupons;
    /**
     * adx 配置信息
     */
    private TicketAdx ticketAdx;
    /**
     * adx 素材列表
     */
    private List<TicketAdxCreative> ticketAdxCreatives;
    /**
     * 激励视频 配置信息
     */
    private TicketInspireVideo ticketInspireVideo;
    /**
     * 激励视频 素材列表
     */
    private List<TicketInspireVideoCreative> ticketInspireVideoCreatives;
    /**
     * 该广告券配置的素材列表
     */
    private List<TicketAssets> assets;
    /**
     * 该广告券配置的模板素材列表
     */
    private List<TicketTemplateAssets> templateAssets;
    /**
     * 广告券地域规则
     */
    private Rule region;
    /**
     * 广告券广告位规则
     */
    private Rule position;
    /**
     * 广告券时间段规则
     */
    private Rule timeline;
    /**
     * 广告券频次规则
     */
    private Rule times;
    /**
     * 广告位组频次规则（流量包）
     */
    private Rule positionGroup;
    /**
     * 广告券组地域定向指定ip库规则
     */
    private Rule ipLib;
    /**
     * 人群包定向（弃用）
     */
    private Rule crowdPackage;
    /**
     * ADX券包
     */
    private Rule ticketPackage;
    /**
     * 已安装包名定向
     */
    private Rule appPackage;
    /**
     * 媒体包名定向
     */
    private Rule mediaAppPackageRule;
    /**
     * ADX App ID 定向
     */
    private Rule adxAppIdRule;

    /**
     * Adx 广告位 ID 定向
     */
    private Rule adxTagIdRule;
    /**
     * 人群包定向
     */
    private TicketCrowd ticketCrowd;
    /**
     * 落地页AB测试计划
     */
    private List<TicketLandPlan> landPlans;

    /**
     * 广告券-分时段对广告位限制配置
     */
    private List<TicketPositionTimesLimitConfig> positionTimesLimitConfigs;

    /**
     * 运营商
     */
    private Rule isp;
    /**
     * 网络类型：0=未知网络，1=WIFI，2=2G，3-3G,4=4G，5=5G
     */
    private Rule networkType;
    /**
     * 广告位质量:1优质，2终端，3长尾，4低质
     */
    private Rule adQuality;
    /**
     * 活动定向
     */
    private Rule activityOrientation;
    /**
     * 新老用户: 0老用户，1新用户
     */
    private Rule newAndOldUsers;
    /**
     * 个推性别定向：男-010qww，女-010qwq，未知-none
     */
    private Rule getuiSex;

    /**
     * 百度性别定向，黑白名单
     */
    private Rule besGender;

    /**
     * 百度年龄定向，黑白名单
     */
    private Rule besAge;

    /**
     * 手机品牌
     */
    private Rule phoneBrand;

    /**
     * ADX App 入口流量定向
     */
    private Rule adxAPPEntrance;

    /**
     * AppID包定向
     */
    private Rule appIdPackage;

    /**
     * 国家定向黑白名单
     */
    private Rule country;
    /**
     * 百度looklike 定向
     */
    private Rule baiduLookLikeRule;

    /**
     * 投放时段分钟级
     */
    private Rule timeSlotMinuteRule;

    /**
     * 自建站落地页落地页测试计划
     */
    private List<TicketLoadingPageConfig> ticketLpConfigs;

    /**
     * 券关联的流量包id
     */
    private List<Long> flowPackageIds;

    public Rule getTimeSlotMinuteRule() {
        return timeSlotMinuteRule;
    }

    public void setTimeSlotMinuteRule(Rule timeSlotMinuteRule) {
        this.timeSlotMinuteRule = timeSlotMinuteRule;
    }

    public Rule getBaiduLookLikeRule() {
        return baiduLookLikeRule;
    }

    public void setBaiduLookLikeRule(Rule baiduLookLikeRule) {
        this.baiduLookLikeRule = baiduLookLikeRule;
    }

    public Rule getNetworkType() {
        return networkType;
    }

    public void setNetworkType(Rule networkType) {
        this.networkType = networkType;
    }

    public Rule getAdQuality() {
        return adQuality;
    }

    public void setAdQuality(Rule adQuality) {
        this.adQuality = adQuality;
    }

    public Rule getActivityOrientation() {
        return activityOrientation;
    }

    public void setActivityOrientation(Rule activityOrientation) {
        this.activityOrientation = activityOrientation;
    }

    public List<TicketTemplateAssets> getTemplateAssets() {
        return templateAssets;
    }

    public void setTemplateAssets(List<TicketTemplateAssets> templateAssets) {
        this.templateAssets = templateAssets;
    }

    public Rule getTicketPackage() {
        return ticketPackage;
    }

    public void setTicketPackage(Rule ticketPackage) {
        this.ticketPackage = ticketPackage;
    }

    public List<TicketInspireVideoCreative> getTicketInspireVideoCreatives() {
        return ticketInspireVideoCreatives;
    }

    public void setTicketInspireVideoCreatives(List<TicketInspireVideoCreative> ticketInspireVideoCreatives) {
        this.ticketInspireVideoCreatives = ticketInspireVideoCreatives;
    }

    public TicketInspireVideo getTicketInspireVideo() {
        return ticketInspireVideo;
    }

    public void setTicketInspireVideo(TicketInspireVideo ticketInspireVideo) {
        this.ticketInspireVideo = ticketInspireVideo;
    }

    public TicketAdx getTicketAdx() {
        return ticketAdx;
    }

    public void setTicketAdx(TicketAdx ticketAdx) {
        this.ticketAdx = ticketAdx;
    }

    public List<TicketAdxCreative> getTicketAdxCreatives() {
        return ticketAdxCreatives;
    }

    public void setTicketAdxCreatives(List<TicketAdxCreative> ticketAdxCreatives) {
        this.ticketAdxCreatives = ticketAdxCreatives;
    }

    public TicketCouponsInfo getTicketCouponsInfo() {
        return ticketCouponsInfo;
    }

    public void setTicketCouponsInfo(TicketCouponsInfo ticketCouponsInfo) {
        this.ticketCouponsInfo = ticketCouponsInfo;
    }

    public List<TicketAssetsCoupons> getAssetsCoupons() {
        return assetsCoupons;
    }

    public void setAssetsCoupons(List<TicketAssetsCoupons> assetsCoupons) {
        this.assetsCoupons = assetsCoupons;
    }

    public Rule getIpLib() {
        return ipLib;
    }

    public void setIpLib(Rule ipLib) {
        this.ipLib = ipLib;
    }

    public List<TicketAssets> getAssets() {
        return assets;
    }

    public void setAssets(List<TicketAssets> assets) {
        this.assets = assets;
    }

    public Rule getRegion() {
        return region;
    }

    public void setRegion(Rule region) {
        this.region = region;
    }

    public Rule getPosition() {
        return position;
    }

    public void setPosition(Rule position) {
        this.position = position;
    }

    public Rule getTimeline() {
        return timeline;
    }

    public void setTimeline(Rule timeline) {
        this.timeline = timeline;
    }

    public Rule getTimes() {
        return times;
    }

    public void setTimes(Rule times) {
        this.times = times;
    }

    public Rule getPositionGroup() {
        return positionGroup;
    }

    public void setPositionGroup(Rule positionGroup) {
        this.positionGroup = positionGroup;
    }

    public Rule getCrowdPackage() {
        return crowdPackage;
    }

    public void setCrowdPackage(Rule crowdPackage) {
        this.crowdPackage = crowdPackage;
    }

    public Rule getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(Rule appPackage) {
        this.appPackage = appPackage;
    }

    public Rule getMediaAppPackageRule() {
        return mediaAppPackageRule;
    }

    public void setMediaAppPackageRule(Rule mediaAppPackageRule) {
        this.mediaAppPackageRule = mediaAppPackageRule;
    }

    public Rule getAdxAppIdRule() {
        return adxAppIdRule;
    }

    public void setAdxAppIdRule(Rule adxAppIdRule) {
        this.adxAppIdRule = adxAppIdRule;
    }

    public Rule getAdxTagIdRule() {
        return adxTagIdRule;
    }

    public void setAdxTagIdRule(Rule adxTagIdRule) {
        this.adxTagIdRule = adxTagIdRule;
    }

    public TicketCrowd getTicketCrowd() {
        return ticketCrowd;
    }

    public void setTicketCrowd(TicketCrowd ticketCrowd) {
        this.ticketCrowd = ticketCrowd;
    }

    public List<TicketPositionTimesLimitConfig> getPositionTimesLimitConfigs() {
        return positionTimesLimitConfigs;
    }

    public void setPositionTimesLimitConfigs(List<TicketPositionTimesLimitConfig> positionTimesLimitConfigs) {
        this.positionTimesLimitConfigs = positionTimesLimitConfigs;
    }

    public List<TicketLandPlan> getLandPlans() {
        return landPlans;
    }

    public void setLandPlans(List<TicketLandPlan> landPlans) {
        this.landPlans = landPlans;
    }

    public Rule getIsp() {
        return isp;
    }

    public void setIsp(Rule isp) {
        this.isp = isp;
    }

    public Rule getNewAndOldUsers() {
        return newAndOldUsers;
    }

    public void setNewAndOldUsers(Rule newAndOldUsers) {
        this.newAndOldUsers = newAndOldUsers;
    }

    public Rule getGetuiSex() {
        return getuiSex;
    }

    public void setGetuiSex(Rule getuiSex) {
        this.getuiSex = getuiSex;
    }

    public Rule getBesGender() {
        return besGender;
    }

    public void setBesGender(Rule besGender) {
        this.besGender = besGender;
    }

    public Rule getBesAge() {
        return besAge;
    }

    public void setBesAge(Rule besAge) {
        this.besAge = besAge;
    }

    public Rule getPhoneBrand() {
        return phoneBrand;
    }

    public void setPhoneBrand(Rule phoneBrand) {
        this.phoneBrand = phoneBrand;
    }

    public Rule getAdxAPPEntrance() {
        return adxAPPEntrance;
    }

    public void setAdxAPPEntrance(Rule adxAPPEntrance) {
        this.adxAPPEntrance = adxAPPEntrance;
    }

    public Rule getAppIdPackage() {
        return appIdPackage;
    }

    public void setAppIdPackage(Rule appIdPackage) {
        this.appIdPackage = appIdPackage;
    }

    public List<TicketLoadingPageConfig> getTicketLpConfigs() {
        return ticketLpConfigs;
    }

    public void setTicketLpConfigs(List<TicketLoadingPageConfig> ticketLpConfigs) {
        this.ticketLpConfigs = ticketLpConfigs;
    }

    public Rule getCountry() {
        return country;
    }

    public void setCountry(Rule country) {
        this.country = country;
    }

    public List<Long> getFlowPackageIds() {
        return flowPackageIds;
    }

    public void setFlowPackageIds(List<Long> flowPackageIds) {
        this.flowPackageIds = flowPackageIds;
    }
}
