package com.bxm.adsprod.model.so.rules;

import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Sets;

/**
 * <p>
 *     广告券名单通用规则
 * </p>
 * <pre>
 *     {item},{item},{item}
 *
 *     item=名单
 * </pre>
 *
 * @author kerry.jiang
 * @date 2021/6/16 20:29
 */
public class TicketItemsSo extends RuleSo {

    /**
     * 名单
     */
    @JSONField(deserialize = false, serialize = false)
    private Set<String> items = Sets.newHashSet();

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();
        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] infoArray = StringUtils.split(value, ',');

        for (String s : infoArray) {
            this.items.add(s);
        }
    }

    public Set<String> getItems() {
        return items;
    }
}
