/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

import java.time.LocalTime;
import java.util.List;

/**
 * 广告券时间段分钟级规则
 * <pre>
 *     {startTime}-{endTime}
 *     12:30-18:00
 *     startTime=开始时间。
 *     endTime=结束时间。
 * </pre>
 * @author tangxiao
 * @date 2023-06-26
 */
public class TicketTimeSlotMinuteRuleSo extends AbstractTwoRule {

    @JSONField(deserialize = false, serialize = false)
    private final List<Entry> entries = Lists.newArrayList();

    @Override
    protected void addItem(String one, String two) {
        this.entries.add(new Entry(one, two));
    }

    @Override
    protected boolean isFirstInt() {
        return false;
    }

    public List<Entry> getEntries() {
        return entries;
    }

    @Override
    protected void addItem(int one, String two) {}

    @Data
    public static class Entry {
        private LocalTime startTime;
        private LocalTime endTime;

        public Entry(String startTime, String endTime) {
            if (StringUtils.isNotBlank(startTime)) {
                this.startTime = LocalTime.parse(startTime);
            }
            if (StringUtils.isNotBlank(endTime)) {
                this.endTime = LocalTime.parse(endTime);
            }
        }
    }

    public boolean isNotInTimeSlotMinute() {
        LocalTime now = LocalTime.now();
        for (TicketTimeSlotMinuteRuleSo.Entry entry : entries) {
            LocalTime startTime = entry.getStartTime();
            LocalTime endTime = entry.getEndTime();
            boolean inTime = now.isAfter(startTime) && now.isBefore(endTime);
            if (inTime) {
                return false;
            }
        }
        return true;
    }
}
