package com.bxm.adsprod.facade.ticket;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 广告券频次规则
 * <pre>
 *     {cycle}-{type}-{count}
 *
 *     cycle保存规则更新：cycle即为天数，兼容上一版本每天即为1
 *     cycle保存规则更新时间：2018-6-6 10:58:52 by kk.xie
 *
 *     type=类型。1- 曝光、2- 点击
 *     count=次数
 * </pre>
 * @author allen
 * @date 2017-12-06
 */
public class TicketTimesRuleSo extends AbstractThreeRule {

    @JSONField(deserialize = false, serialize = false)
    private List<Entry> entries = Lists.newArrayList();

    @Override
    protected void addItem(int one, int two, long three) {
        this.entries.add(new Entry(one, two, three));
    }

    public List<Entry> getEntries() {
        return entries;
    }

    public static class Entry {

        public static final int CYCLE_EVERYDAY = 1;
        public static final int CYCLE_EVERYWEEK = 2;

        public static final int TYPE_VIEW = 1;
        public static final int TYPE_CLICK = 2;

        private int cycle;
        private int type;
        private long count;

        public Entry(int cycle, int type, long count) {
            this.cycle = cycle;
            this.type = type;
            this.count = count;
        }

        public int getCycle() {
            return cycle;
        }

        public void setCycle(int cycle) {
            this.cycle = cycle;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public long getCount() {
            return count;
        }

        public void setCount(long count) {
            this.count = count;
        }
    }

}
