package com.bxm.adsprod.facade.ticket.simulation;

import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketWithWeight;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @since 1.0.0
 */
public class SimulationResult implements Serializable {

    private static final long serialVersionUID = -6638481422835767616L;

    /**
     * 请求参数
     */
    private Object params;
    /**
     * 原因
     */
    private Object reason;
    /**
     * 可出券列表
     */
    private List<String> tickets = Lists.newArrayList();
    /**
     * 过滤信息
     */
    private Map<Object, List<String>> filterMessage = Maps.newHashMap();

    public Object getParams() {
        return params;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    public Object getReason() {
        return reason;
    }

    public void setReason(Object reason) {
        this.reason = reason;
    }

    public Map<Object, List<String>> getFilterMessage() {
        return filterMessage;
    }

    public void setFilterMessage(Map<Object, List<String>> filterMessage) {
        Map<Object, List<String>> ts = Maps.newHashMap();

        for (Map.Entry<Object, List<String>> objectListEntry : filterMessage.entrySet()) {
            Object key = objectListEntry.getKey();
            List<String> value = objectListEntry.getValue();
            ts.put(key, value);
        }
        this.filterMessage = ts;
    }

    public SimulationResult standby(TicketCache e) {
        this.tickets.add(String.valueOf(e.getId()));
        return this;
    }

    public SimulationResult normal(List<TicketWithWeight> list) {
        for (TicketWithWeight ticketWithWeight : list) {
            this.tickets.add(String.valueOf(ticketWithWeight.getTicketId()));
        }
        return this;
    }

    public List<String> getTickets() {
        return tickets;
    }
}
