package com.bxm.adsprod.integration.activity;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.activites.facade.model.ActivityRequest;
import com.bxm.activites.facade.model.InfoActivity;
import com.bxm.activites.facade.service.ActivityBaseService;
import com.bxm.activites.facade.service.ActivityService;
import org.springframework.stereotype.Service;

/**
 * 调用活动服务实现
 *
 * @ClassName ActivitiesServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/24 18:55
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/24 18:55
 **/
@Service
public class ActivitiesServiceImpl implements ActivitiesService {

    @Reference(version = "1.0.0")
    private ActivityBaseService activityBaseService;

    @Reference(version = "1.0.0")
    private ActivityService activityService;

    @Override
    public int findUserJoinTimes(String uid, String positionId, String activityId) {
        ActivityRequest activityRequest = new ActivityRequest();
        activityRequest.setUid(uid);
        activityRequest.setPosition(positionId);
        activityRequest.setActivityid(activityId);
        return activityBaseService.getTime(activityRequest);
    }

    @Override
    public boolean subAwardAmount(Long acticityId, Long  awardId){
        return activityService.subAwardAmount(acticityId, awardId);
    }

    @Override
    public InfoActivity getActMsg(String acticityId) {
        return activityService.getActMsg(acticityId);
    }
}
