/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.integration.adsmanager;

import com.bxm.adsprod.integration.adsmanager.AdsmanagerConfiguration;
import com.bxm.adsprod.integration.adsmanager.AdsmanagerService;
import com.bxm.adsprod.integration.adsmanager.RestfulResponse;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.PathUtils;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={AdsmanagerConfiguration.class})
public class AdsmanagerServiceHttpImpl
implements AdsmanagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsmanagerServiceHttpImpl.class);
    @Autowired
    private AdsmanagerConfiguration configuration;

    @Override
    public boolean updateAdTicket(BigInteger ticketId, byte status, int reason) {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(6000).build();
        HashMap uriVariables = Maps.newHashMap();
        uriVariables.put("id", ticketId);
        uriVariables.put("status", status);
        uriVariables.put("reason", reason);
        String url = PathUtils.appendToHost((String)this.configuration.getHost(), (Object[])new Object[]{"adsmanager", "updateAdTicket?id={id}&status={status}&reason={reason}"});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access url: {}, parameters: {}", (Object)url, (Object)uriVariables);
        }
        HttpEntity entity = HttpEntity.EMPTY;
        ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)entity, String.class, (Map)uriVariables);
        RestfulResponse restfulResponse = (RestfulResponse)JsonHelper.convert((String)((String)responseEntity.getBody()), RestfulResponse.class);
        return restfulResponse.isSuccessed();
    }

    @Override
    public boolean addTicketCostLog(BigInteger ticketId, double costRds, double cost) {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(6000).build();
        HashMap uriVariables = Maps.newHashMap();
        uriVariables.put("ticketId", ticketId);
        uriVariables.put("costRds", costRds);
        uriVariables.put("cost", cost);
        String url = PathUtils.appendToHost((String)this.configuration.getHost(), (Object[])new Object[]{"adsmanager", "addTicketCostLog?ticketId={ticketId}&costRds={costRds}&cost={cost}"});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access url: {}, parameters: {}", (Object)url, (Object)uriVariables);
        }
        HttpEntity entity = HttpEntity.EMPTY;
        ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)entity, String.class, (Map)uriVariables);
        RestfulResponse restfulResponse = (RestfulResponse)JsonHelper.convert((String)((String)responseEntity.getBody()), RestfulResponse.class);
        return restfulResponse.isSuccessed();
    }
}

