package com.bxm.adsprod.model.dao.ticket;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.*;
import com.bxm.warcar.utils.Constants;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.RandomUtils;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * @author allen
 * @date 2017-12-04
 */
public class Ticket implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    public static final byte SETTLE_TYPE_CPC = 1;
    public static final byte SETTLE_TYPE_CPA = 2;

    /**
     * 常规券
     */
    public static final byte TYPE_NORMAL = 1;
    /**
     * 备用券
     */
    public static final byte TYPE_STANDBY = 2;

    /**
     * 开启
     */
    public static final byte STATUS_OPEN = 1;
    /**
     * 暂停
     */
    public static final byte STATUS_PAUSE = 2;
    /**
     * 停止
     */
    public static final byte STATUS_CLOSE = 3;
    /**
     * 已删除
     */
    public static final byte STATUS_DELETED = 99;

    public static final int PAUSE_REASON_NONE = 0;
    /**
     * 日预算不足
     */
    public static final int PAUSE_REASON_OUT_OF_DAILYBUDGET = 1;
    /**
     * 余额不足
     */
    public static final int PAUSE_REASON_BALANCE_NOT_ENOUGHT = 2;
    /**
     * 未到投放日期
     */
    public static final int PAUSE_REASON_NO_START = 3;
    /**
     * 已结束
     */
    public static final int PAUSE_REASON_ENDED = 4;
    /**
     * 时间段预算不足
     */
    public static final int PAUSE_REASON_OUT_OF_TIMEBUDGET = 5;
    /**
     * 其他原因
     */
    public static final int PAUSE_REASON_OTHER = 99;

    private BigInteger id;
    private String name;
    private BigInteger advertiser;
    private Byte settleType;
    private Integer price;
    private Byte type;
    private Integer budgetDaily;
    private String domainCode;
    private Double standaloneCost;
    private String url;
    private Date validStartDate;
    private Date validEndDate;
    /**
     * 是否支持微信
     * @see Constants#YES
     * @see Constants#NO
     */
    private Byte isSupportWechat;
    /**
     * 用户评分及格分数线
     */
    private Integer userGradePassScore;
    private Byte status;
    private Integer pauseReason;
    /**
     * CPA 预期价格
     */
    private Integer cpaPrice;
    /**
     * 底价
     */
    private Integer floorPrice;
    /**
     * 支持的平台
     */
    private List<TicketOs> oss;
    /**
     * 标签
     */
    private List<Tag> tags;
    /**
     * 开关配置
     */
    private List<TicketOnoff> onoffs;
    /**
     * 素材
     */
    @Deprecated
    private List<TicketAssets> assets;
    /**
     * 价格配置
     */
    private List<TicketPrice> prices;
    /**
     * 权重干预系数
     */
    private List<TicketWeightMif> mifs;

    /**
     * 广告券获得/点击等所有触发时间
     */
    private Date time;
    /**
     * 广告券票据号，当得到这种广告券之后会创建一个票据作为后面点击等数据的统计依据。
     */
    private String billid;
    /**
     * 本次点击实际出价
     */
    private Integer offerPrice;
    /**
     * 是否是OCPC广告
     */
    private Byte ocpc;
    /**
     * 屏蔽阈值
     */
    private Integer closeThreshold;
    /**
     * 本次获取广告券所对应的素材
     */
    private TicketAssets offerAssets;

    /**
     * 广告组 ID
     */
    private Long groupId;

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isCPC() {
        return null != settleType && settleType == SETTLE_TYPE_CPC;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isNormalType() {
        return null != type && type == TYPE_NORMAL;
    }

    /**
     * 该广告券的状态是否为打开(可用)
     * @return
     */
    @JSONField(serialize = false, deserialize = false)
    public boolean isAvailableForStatus() {
        return null != status && status == STATUS_OPEN;
    }

    /**
     * 该广告券是否有可用的素材
     * @return
     */
    @Deprecated
    @JSONField(serialize = false, deserialize = false)
    public boolean isAvailableForAssets() {
        if (CollectionUtils.isEmpty(assets)) {
            return false;
        }
        for (TicketAssets asset : assets) {
            if (asset.isAvailable()) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public TicketAssets randomAssets() {
        // 筛选掉关闭的素材
        List<TicketAssets> rst = Lists.newArrayList();
        for (TicketAssets asset : assets) {
            if (asset.isAvailable()) {
                rst.add(asset);
            }
        }

        return rst.size() == 0 ? null : rst.get(RandomUtils.nextInt(rst.size()));
    }

    public boolean isSupportedOs(int os) {
        if (CollectionUtils.isEmpty(oss)) {
            return false;
        }
        for (TicketOs ticketOs : oss) {
            if (ticketOs.getSupportOs() == os) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @JSONField(serialize = false, deserialize = false)
    public boolean isSupportedWechat() {
        return null != isSupportWechat && isSupportWechat == Constants.YES;
    }

    public String getSettleTypeName() {
        if (null == settleType) {
            return "UNKNOWN";
        }
        return settleType == SETTLE_TYPE_CPC ? "CPC" :
                settleType == SETTLE_TYPE_CPA ? "CPA" :
                        "UNKNOWN";
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigInteger getAdvertiser() {
        return advertiser;
    }

    public void setAdvertiser(BigInteger advertiser) {
        this.advertiser = advertiser;
    }

    public Byte getSettleType() {
        return settleType;
    }

    public void setSettleType(Byte settleType) {
        this.settleType = settleType;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Integer getBudgetDaily() {
        return budgetDaily;
    }

    public void setBudgetDaily(Integer budgetDaily) {
        this.budgetDaily = budgetDaily;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Double getStandaloneCost() {
        return standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Byte getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Byte isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public List<TicketOnoff> getOnoffs() {
        return onoffs;
    }

    public void setOnoffs(List<TicketOnoff> onoffs) {
        this.onoffs = onoffs;
    }

    public List<TicketOs> getOss() {
        return oss;
    }

    public void setOss(List<TicketOs> oss) {
        this.oss = oss;
    }

    @Deprecated
    public List<TicketAssets> getAssets() {
        return assets;
    }

    @Deprecated
    public void setAssets(List<TicketAssets> assets) {
        this.assets = assets;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public List<TicketPrice> getPrices() {
        return prices;
    }

    public void setPrices(List<TicketPrice> prices) {
        this.prices = prices;
    }

    public List<TicketWeightMif> getMifs() {
        return mifs;
    }

    public void setMifs(List<TicketWeightMif> mifs) {
        this.mifs = mifs;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getBillid() {
        return billid;
    }

    public void setBillid(String billid) {
        this.billid = billid;
    }

    public Integer getCpaPrice() {
        return cpaPrice;
    }

    public void setCpaPrice(Integer cpaPrice) {
        this.cpaPrice = cpaPrice;
    }

    public Integer getFloorPrice() {
        return floorPrice;
    }

    public void setFloorPrice(Integer floorPrice) {
        this.floorPrice = floorPrice;
    }

    public Integer getOfferPrice() {
        return offerPrice;
    }

    public void setOfferPrice(Integer offerPrice) {
        this.offerPrice = offerPrice;
    }

    public Byte getOcpc() {
        return ocpc;
    }

    public void setOcpc(Byte ocpc) {
        this.ocpc = ocpc;
    }

    public Integer getCloseThreshold() {
        return closeThreshold;
    }

    public void setCloseThreshold(Integer closeThreshold) {
        this.closeThreshold = closeThreshold;
    }

    public TicketAssets getOfferAssets() {
        return offerAssets;
    }

    public void setOfferAssets(TicketAssets offerAssets) {
        this.offerAssets = offerAssets;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
