/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 广告券时间段规则
 * <pre>
 *     {start}-{end}-{limit}
 *
 *     start=开始时间。单位：小时
 *     end=结束时间。单位：小时
 *     limit=限额。金额或张，金额单位：厘
 * </pre>
 * @author allen
 * @date 2017-12-06
 */
public class TicketTimelineRuleSo extends AbstractThreeRule {

    @JSONField(deserialize = false, serialize = false)
    private List<Entry> entries = Lists.newArrayList();

    @Override
    protected void addItem(int one, int two, long three) {
        this.entries.add(new Entry(one, two, three));
    }

    public List<Entry> getEntries() {
        return entries;
    }

    public static class Entry {

        private int startHour;
        private int endHour;
        private long limit;

        public Entry(int startHour, int endHour, long limit) {
            this.startHour = startHour;
            this.endHour = endHour;
            this.limit = limit;
        }

        public int getStartHour() {
            return startHour;
        }

        public void setStartHour(int startHour) {
            this.startHour = startHour;
        }

        public int getEndHour() {
            return endHour;
        }

        public void setEndHour(int endHour) {
            this.endHour = endHour;
        }

        public long getLimit() {
            return limit;
        }

        public void setLimit(long limit) {
            this.limit = limit;
        }
    }
}
