package com.bxm.adsprod.test;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.commons.CachePushException;
import com.bxm.adsprod.facade.commons.CachePushableService;
import com.bxm.adsprod.facade.ticket.NoValidTicketException;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketRequest;
import com.bxm.adsprod.facade.ticket.TicketService;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author allen
 * @since V1.0.0 2017/12/07
 */
@Component
public class AdsprodIntegration {

    @Reference(version = "1.0.0")
    private TicketService ticketService;
//    @Reference(version = "1.0.0")
//    private CachePushableService cachePushableService;
    @Reference(version = "1.0.0")
    private AdvertiserService advertiserService;

    public TicketService getTicketService() {
        return ticketService;
    }
//
//    public CachePushableService getCachePushableService() {
//        return cachePushableService;
//    }

    public AdvertiserService getAdvertiserService() {
        return advertiserService;
    }

    public void getTicket() {
        TicketRequest request = new TicketRequest();
        request.setUid("1");
        request.setImei("IMEI");
        request.setPosition("2");
        request.setActivity("3");
        request.setIp("192.168.3.10");
        try {
            Ticket ticket = ticketService.get(request);
            System.out.println(ticket);
        } catch (NoValidTicketException e) {
            System.out.println("没有可用的广告券");
        }
    }

//    public String pushCache(String serviceName, Map<String, Object> parameters, byte[] data) throws CachePushException {
//        return cachePushableService.push(serviceName, parameters, data);
//    }
}
