package com.bxm.adsprod.test.region;

import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author allen
 * @since 1.0.0
 */
public class RegionMatchingTest {

    private static final String[] OLD = new String[] {
            "七台河市", "三亚市", "三明市", "三沙市", "三门峡市", "上海市", "上海省", "上饶市", "东莞市", "东营市",
            "中卫市", "中山市", "临夏回族自治州市", "临汾市", "临沂市", "临沧市", "丹东市", "丽水市", "丽江市",
            "乌兰察布市", "乌海市", "乌鲁木齐市", "乐山市", "九江市", "云南省", "云浮市", "五家渠市", "亳州市",
            "伊春市", "伊犁哈萨克自治州市", "佛山市", "佳木斯市", "保定市", "保山市", "信阳市", "克孜勒苏柯尔克孜自治州市",
            "克拉玛依市", "六安市", "六盘水市", "兰州市", "兴安盟", "内江市", "内蒙古自治区", "凉山彝族自治州市",
            "包头市", "北京市", "北京市", "北海市", "十堰市", "南京市", "南充市", "南宁市", "南平市", "南昌市",
            "南通市", "南阳市", "博尔塔拉蒙古自治州市", "厦门市", "双鸭山市", "台州市", "台湾市", "台湾市",
            "合肥市", "吉安市", "吉林市", "吉林省", "吐鲁番市", "吕梁市", "吴忠市", "周口市", "呼伦贝尔市",
            "呼和浩特市", "和田市", "咸宁市", "咸阳市", "哈密市", "哈尔滨市", "唐山市", "商丘市", "商洛市",
            "喀什市", "嘉兴市", "嘉峪关市", "四川省", "四平市", "固原市", "图木舒克市", "塔城市", "大兴安岭市",
            "大同市", "大庆市", "大理白族自治州市", "大连市", "天水市", "天津市", "天津市", "太原市", "威海市",
            "娄底市", "孝感市", "宁夏回族自治区", "宁德市", "宁波市", "安庆市", "安康市", "安徽省", "安阳市",
            "安顺市", "定西市", "宜宾市", "宜昌市", "宜春市", "宝鸡市", "宣城市", "宿州市", "宿迁市", "山东省",
            "山南市", "山西省", "岳阳市", "崇左市", "巴中市", "巴彦淖尔市", "巴音郭楞蒙古自治州市", "常州市",
            "常德市", "平凉市", "平顶山市", "广东省", "广元市", "广安市", "广州市", "广西壮族市", "庆阳市",
            "廊坊市", "延安市", "延边朝鲜族自治州市", "开封市", "张家口市", "张家界市", "张掖市", "徐州市",
            "德宏傣族景颇族自治州市", "德州市", "德阳市", "忻州市", "怀化市", "怒江傈僳族自治州市", "恩施土家族苗族自治州市",
            "惠州市", "成都市", "扬州市", "承德市", "抚州市", "抚顺市", "拉萨市", "揭阳市", "攀枝花市", "文山壮族苗族自治州市",
            "新乡市", "新余市", "新疆维吾尔自治区", "无锡市", "日喀则市", "日照市", "昆明市", "昌吉回族自治州市",
            "昌都市", "昭通市", "晋中市", "晋城市", "普洱市", "景德镇市", "曲靖市", "朔州市", "朝阳市", "本溪市", "来宾市",
            "杭州市", "松原市", "林芝市", "果洛藏族自治州市", "枣庄市", "柳州市", "株洲市", "桂林市", "梅州市", "梧州市",
            "楚雄彝族自治州市", "榆林市", "武威市", "武汉市", "毕节市", "永州市", "汉中市", "汕头市", "汕尾市", "江苏省",
            "江西省", "江门市", "池州市", "沈阳市", "沧州市", "河北省", "河南省", "河池市", "河源市", "泉州市", "泰安市",
            "泰州市", "泸州市", "洛阳市", "济南市", "济宁市", "浙江省", "海东市", "海北藏族自治州市", "海南省", "海南藏族自治州市",
            "海口市", "海西蒙古族藏族自治州市", "淄博市", "淮北市", "淮南市", "淮安市", "深圳市", "清远市", "温州市", "渭南市",
            "湖北省", "湖南省", "湖州市", "湘潭市", "湘西土家族苗族自治州市", "湛江市", "滁州市", "滨州市", "漯河市", "漳州市",
            "潍坊市", "潮州市", "澳门特别行政区", "澳门特别行政区", "濮阳市", "烟台市", "焦作市", "牡丹江市", "玉林市",
            "玉树藏族自治州市", "玉溪市", "珠海市", "甘南藏族自治州市", "甘孜藏族自治州市", "甘肃省", "白城市", "白山市",
            "白银市", "百色市", "益阳市", "盐城市", "盘锦市", "眉山市", "石嘴山市", "石家庄市", "石河子市", "神农架", "福州市",
            "福建省", "秦皇岛市", "红河哈尼族彝族自治州市", "绍兴市", "绥化市", "绵阳市", "聊城市", "肇庆市", "自贡市", "舟山市",
            "芜湖市", "苏州市", "茂名市", "荆州市", "荆门市", "荷泽市", "莆田市", "莱芜市", "萍乡市", "营口市", "葫芦岛市",
            "蚌埠市", "衡水市", "衡阳市", "衢州市", "襄阳市", "西双版纳傣族自治州市", "西宁市", "西安市", "西藏市", "许昌市",
            "贵州省", "贵港市", "贵阳市", "贺州市", "资阳市", "赣州市", "赤峰市", "辽宁省", "辽源市", "辽阳市", "达州市",
            "运城市", "连云港市", "迪庆藏族自治州市", "通化市", "通辽市", "遂宁市", "遵义市", "邢台市", "那曲市", "邯郸市",
            "邵阳市", "郑州市", "郴州市", "鄂尔多斯市", "鄂州市", "酒泉市", "重庆市", "重庆市", "金华市", "钦州市", "铁岭市",
            "铜仁市", "铜川市", "铜陵市", "银川市", "锡林郭勒盟", "锦州市", "镇江市", "长春市", "长沙市", "长治市", "阜新市",
            "阜阳市", "防城港市", "阳江市", "阳泉市", "阿克苏市", "阿勒泰市", "阿坝藏族羌族自治州市", "阿拉善盟", "阿拉尔市",
            "阿里市", "陇南市", "陕西省", "随州市", "雅安市", "青岛市", "青海省", "鞍山市", "韶关市", "香港特别行政区",
            "香港特别行政区", "马鞍山市", "驻马店市", "鸡西市", "鹤壁市", "鹤岗市", "鹰潭市", "黄冈市", "黄南藏族自治州市",
            "黄山市", "黄石市", "黑河市", "黑龙江省", "黔东南苗族侗族自治州市", "黔南布依族苗族自治州市", "黔西南布依族苗族自治州市",
            "齐齐哈尔市", "龙岩市"
    };

    public static void main(String[] args) {
        List<String> result = Lists.newArrayList();
        List<String> out = Lists.newArrayList();
        for (String o : OLD) {
            String s = Regions.NEWS.get(o);

            if (StringUtils.isNotEmpty(s)) {
                // 完全匹配
                result.add(o + "_" + o + "_" + s);
                continue;
            }

            String[] strings = get(o);
            if (null != strings) {
                result.add(o + "_" + strings[0] + "_" + strings[1]);
                continue;
            }

            String[] matching = matching(o);
            if (null != matching) {
                result.add(o + "_" + matching[0] + "_" + matching[1]);
                continue;
            }

            out.add(o);
        }

        for (String s : result) {
            System.out.println(s);
        }
        for (String s : out) {
            System.out.println(s);
        }
    }

    private static String[] get(String s) {
        Set<Map.Entry<String, String>> entries = Regions.NEWS.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (StringUtils.startsWith(entry.getKey(), s)) {
                return new String[] { entry.getKey(), entry.getValue() };
            }
        }
        return null;
    }

    private static String[] matching(String s) {
        Set<Map.Entry<String, String>> entries = Regions.NEWS.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (StringUtils.startsWith(entry.getKey(), s)) {
                return new String[] { entry.getKey(), entry.getValue() };
            }
        }
        return matching(s.substring(0, s.length() - 1));
    }

    static class Item {
        String name;
        String code;
        int matchingChars;
    }
}
