package com.bxm.adsprod.test.ticket;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.ticket.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Random;

/**
 * 礼券出券测试类
 *
 * @ClassName TicketServiceControllerTest
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/6/6 15:39
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/6/6 15:39
 **/
@RestController
@RequestMapping("/test")
public class TicketServiceControllerTest {
    Logger logger = LoggerFactory.getLogger(TicketServiceControllerTest.class);

    @Reference(version = "1.0.0")
    private TicketService ticketService;

    @RequestMapping("/ticket/view")
    public Ticket view(TicketRequest ticketRequest) throws NoValidTicketException {
        logger.info("开始出券...");
        // 出券
        Ticket ticket = ticketService.get(ticketRequest);
        logger.info("结束出券，券：{}",ticket.getId());

        logger.info("开始曝光...");
        // 获取礼券后进行曝光
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setAssetsId(ticket.getOfferAssets().getId());
        viewRequest.setPosition(ticketRequest.getPosition());
        viewRequest.setTicketId(ticket.getId());
        viewRequest.setUid(ticketRequest.getUid());
        ticketService.view(viewRequest);
        logger.info("结束曝光，券：{}",ticket.getId());

        // 随机出发点击
        logger.info("随机偶数触发点击...");
        Random random = new Random();
        int i = random.nextInt(10);
        logger.info("随机数：{}",i);
        if(i % 2 == 0){
            logger.info("触发点击...");
            ClickRequest clickRequest = new ClickRequest();
            clickRequest.setUid(ticketRequest.getUid());
            clickRequest.setAssetsId(ticket.getOfferAssets().getId());
            clickRequest.setPosition(ticketRequest.getPosition());
            clickRequest.setTicketId(ticket.getId());
            clickRequest.setUid(ticketRequest.getUid());
            clickRequest.setValid(false);
            clickRequest.setBillid("billid-1");

            ticketService.click(clickRequest);
            logger.info("触发点击结束，券：{}",ticket.getId());
            logger.info("---------------------------------------------------------------------------------------------------");
        }
        return ticket;
    }
}
