package com.bxm.adsprod.third.common;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(OldConfiguration.class)
public class GuideRedisAutoConfiguration {

    private final OldConfiguration oldConfiguration;

    public GuideRedisAutoConfiguration(OldConfiguration oldConfiguration) {
        this.oldConfiguration = oldConfiguration;
    }

    @Bean
    public JedisPool jedisPoolForOld() {
        return new JedisPool(oldConfiguration, oldConfiguration.getHost(), oldConfiguration.getPort(), oldConfiguration.getTimeout(),
                oldConfiguration.getPassword(), oldConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcherForOld() {
        return new JedisFetcher(jedisPoolForOld());
    }
}
