package com.bxm.adsprod.third.config;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.bxm.warcar.utils.DateHelper;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/11/27 17:07
 */
@Configuration
@EnableConfigurationProperties(OssConfiguration.class)
public class UploadHelper {

    private final static String IMGFILEHOST = "https://m.cudaojia.com/";
    private final static String BUCKETNAME = "bxm-guide";
    private OssConfiguration configuration;

    public UploadHelper(OssConfiguration config) {
        this.configuration = config;
    }

    public Object uploadImg( HttpServletRequest request, String path) throws Exception{

        // 创建一个通用的多部分解析器
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        List<String> files = new ArrayList();
        Iterator iter;
        // 判断 request 是否有文件上传,即多部分请求
        if (multipartResolver.isMultipart(request)) {
            // 转换成多部分request
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            // 取得request中的所有文件名
            iter = multiRequest.getFileNames();

            while (iter.hasNext()) {
                // 取得上传文件
                MultipartFile file = multiRequest.getFile((String) iter.next());
                if (file != null) {
                    // 取得当前上传文件的文件名称
                    String fileName = file.getOriginalFilename();
                    String suffixNmae = fileName.substring(fileName.indexOf("."));
                    // 如果名称不为空,说明该文件存在，否则说明该文件不存在
                    if (StringUtils.isNotBlank(fileName.trim())) {
                        File newFile = new File(request.getSession().getServletContext().getRealPath("/") + fileName);

                        try {
                            if (!newFile.exists()) {
                                newFile.createNewFile();
                            }

                            file.transferTo(newFile);
                            String fileUrl = "dist/" + path + "/" + DateHelper.format(DateHelper.PATTERN_STR14)+ RandomUtils.nextInt() +suffixNmae;
                            files.add(upload(newFile, BUCKETNAME,IMGFILEHOST ,fileUrl));

                        }finally {
                            if (newFile.exists()) {
                                newFile.delete();
                            }

                        }
                        // 上传到阿里云
                    }
                }
            }
        }

        String rs = "[";

        String url;
        for (iter = files.iterator(); iter.hasNext(); rs = rs + "{\"url\":\"" + url + "\"}") {
            url = (String) iter.next();
        }

        rs = rs + "]";
        return  JSON.parse(rs);
    }

    private  String upload(File file, String bucketName, String imgFileHost, String fileUrl) throws ClientException {
        if (file == null) {
            return null;
        }
        // 创建OSS客户端
        OSSClient ossClient = new OSSClient(configuration.getEndPoint(), configuration.getAccessKeyId(), configuration.getAccessKeySecret());
        try {
            // 判断文件容器是否存在，不存在则创建
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                ossClient.createBucket(createBucketRequest);
            }
            // 创建文件路径


            // 上传文件
            PutObjectResult result = ossClient.putObject(new PutObjectRequest(bucketName, fileUrl, file));
            if (null != result) {
                return imgFileHost + fileUrl;
            }
        } finally {
            // 关闭OSS服务，一定要关闭
            ossClient.shutdown();
        }
        return null;
    }

}
