package com.bxm.adsprod.third.constant;

public enum ErrorCode {
    //通用错误码
    E0000000("0000000", "成功"),
    E0000001("0000001", "参数错误"),
    E9999999("9999999", "系统异常"),

    //落地页业务，E0100000开始
    E0100000("0100000", "用户ip未取到"),
    E0100001("0100001", "您的请求太频繁,请稍后重试"),
    E0100002("0100002", "您的请求太频繁,请明天重试"),
    E0100003("0100003", "您的验证码错误,请重试"),
    E0100004("0100004", "您的验证码不存在或已过期,请重试"),
    E0100005("0100005", "第三方错误"),
    E0100006("0100006", "第三方Token错误"),
    ;

    private String code;

    private String desc;

    ErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
