
package com.bxm.adsprod.third.controller;

import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;

/**
 * ClassName:BaseController <br/>
 * Date: 2016年10月9日 上午8:59:58 <br/>
 * .
 *
 * @author zhanglihui
 * @see
 * @since JDK 1.6
 */
public class BaseController {

    /**
     * The logger.
     */
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * Fail result.
     *
     * @param <T> the generic type
     * @param e   the e
     * @return the result< t>
     */
    @ExceptionHandler
    public <T> Result<T> failResult(Exception e) {
        if (e instanceof ThirdException) {
            ThirdException te = (ThirdException) e;
            return this.fail(te.getCode(), te.getDesc());
        } else {
            logger.warn("发生系统错误", e);
            return this.fail(ErrorCode.E9999999);
        }
    }

    public <T> Result<T> failResult(ErrorCode errorCode) {
        logger.warn("发生错误,错误码={}, 错误描述={}", errorCode.getCode(), errorCode.getDesc());
        return this.fail(errorCode);
    }

    /**
     * Success result.
     *
     * @param <T> the generic type
     * @param t   the t
     * @return the result< t>
     */
    public <T> Result<T> successResult(T t) {
        return this.success(t);
    }

    /**
     * Success result.
     *
     * @param <T> the generic type
     * @return the result< t>
     */
    public <T> Result<T> successResult() {
        return this.success(null);
    }

    /**
     * success.
     *
     * @param <T> the generic type
     * @param t   the t
     * @return the result< t>
     */
    private static <T> Result<T> success(T t) {
        Result<T> result = new Result<>();
        result.setCode(ErrorCode.E0000000.getCode());
        if (null != t) {
            result.setData(t);
        }
        result.setDesc(ErrorCode.E0000000.getDesc());
        return result;
    }

    /**
     * 构造一个失败的返回结果.
     *
     * @param <T>  the generic type
     * @param code 错误码枚举
     * @return the error result do
     */
    private static <T> Result<T> fail(ErrorCode code) {
        Result<T> result = new Result<>();
        result.setCode(code.getCode());
        result.setDesc(code.getDesc());
        return result;
    }

    private static <T> Result<T> fail(String code, String desc) {
        Result<T> result = new Result<>();
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }
}
