package com.bxm.adsprod.third.controller;

import com.bxm.adsprod.third.model.LandVo;
import com.bxm.adsprod.third.model.Result;
import com.bxm.adsprod.third.model.third.HeiNiuResult;
import com.bxm.adsprod.third.service.ThirdService;
import com.sun.org.apache.xpath.internal.operations.Bool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**  
* @Title: ThirdController
* @Description:  暴露给第三方的服务
* @author youhaijun
* @date 2018年6月7日
*/  
@RestController
@RequestMapping("/third")
public class ThirdController extends BaseController {

	@Autowired
	private ThirdService thirdService;

	/**
	 * 更新广告IP库
 	 * @param channel 落地页标识，通过落地页id做base64脱敏
	 * @return
	 */
	@RequestMapping(value = "/updateIpLibrary", method = {RequestMethod.GET, RequestMethod.POST})
	public Result<Boolean> updateIpLibrary(String channel, String url, Integer updateType, Integer updateAll, String token) {
		try {
			return successResult(thirdService.updateIpLibrary(channel, url, updateType, updateAll, token));
		} catch (Exception e) {
			return failResult(e);
		}
	}

	/**
	 * 黑牛落地页赠险结果通知
	 *
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/heiNiuResult", method = {RequestMethod.GET, RequestMethod.POST})
	public Result<Boolean> heiNiuResult(HeiNiuResult result, HttpServletRequest request) {
		try {
			return successResult(thirdService.heiNiuResult(result, request));
		} catch (Exception e) {
			return failResult(e);
		}
	}


}
