package com.bxm.adsprod.third.controller.alipay;

import com.bxm.adsprod.third.controller.BaseController;
import com.bxm.adsprod.third.model.Result;
import com.bxm.adsprod.third.service.alipay.AlipayService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author lala
 * @Title: AlipayController
 * @Description: 检测是否是支付宝新用户
 * @date 2018年6月7日
 */
@RestController
@RequestMapping("/alipay")
public class AlipayController extends BaseController {

    @Autowired
    private AlipayService alipayService;

    /**
     * 检查是否值支付宝新用户，如果是，则绑定支付宝
     *
     * @param mobile 手机号码
     * @return
     */
    @RequestMapping(value = "/checkAlipyaMobile", method = {RequestMethod.GET, RequestMethod.POST})
    public Result<Integer> updateIpLibrary(String mobile, String bxmId, String source) {
        try {
            return successResult(alipayService.checkMoblie(mobile, bxmId, source));
        } catch (Exception e) {
            return failResult(e);
        }
    }


}
