package com.bxm.adsprod.third.controller.landpage;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.third.model.landpage.Auth;
import com.bxm.adsprod.third.service.landpage.AuthService;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
 * @author allen
 * @since 1.0.0
 */
@RestController
@RequestMapping("/auth")
public class AuthController {

    private static final String ACCESS_KEY = "7wKgQgMM38xWssgjfnSqYNICzz5Ri9mm";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthController.class);

    @Autowired
    private AuthService authService;


    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public ResponseModel<Object> save(String k,Auth auth) {
        if (!StringUtils.equals(k, ACCESS_KEY)) {
            return ResponseModelFactory.FAILED401();
        }
        try {
            authService.saveOrUpdate(auth);
        }catch (Exception e){
            LOGGER.error(e.getMessage(),e);
            return ResponseModelFactory.FAILED();
        }
        return ResponseModelFactory.SUCCESS(null);
    }

    @RequestMapping(value = "/generate", method = RequestMethod.GET)
    public ResponseModel<Object> generate(@RequestParam("k") String k) {
        if (!StringUtils.equals(k, ACCESS_KEY)) {
            return ResponseModelFactory.FAILED401();
        }
        try {
            return ResponseModelFactory.SUCCESS(UUIDHelper.generate());
        }catch (Exception e){
            LOGGER.error(e.getMessage(),e);
            return ResponseModelFactory.FAILED();
        }
    }

}
