package com.bxm.adsprod.third.exception;

import com.bxm.adsprod.third.constant.ErrorCode;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

public class ThirdException extends Exception implements Serializable {
    private static final long serialVersionUID = 9175885517189519362L;

    private String code;

    private String desc;

    public ThirdException(ErrorCode errorCode) {
        super(errorCode.getDesc());
        this.code = errorCode.getCode();
        this.desc = errorCode.getDesc();
    }

    public ThirdException(String  code, String desc) {
        super(desc);
        this.code = code;
        this.desc = desc;
    }

    public ThirdException(ErrorCode errorCode, Exception e) {
        super(errorCode.getDesc(), e);
        this.code = errorCode.getCode();
        this.desc = errorCode.getDesc();
    }

    public ThirdException(Exception e) {
        super(e);
        this.code = ErrorCode.E9999999.getCode();
        this.desc = e.getMessage();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String toString(){
        return ToStringBuilder.reflectionToString(this);
    }
}
