
package com.bxm.adsprod.third.service;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.dal.activity.LandUserInfoMapper;
import com.bxm.adsprod.dal.entity.LandUserInfoDO;
import com.bxm.adsprod.facade.activity.ActivityKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.constant.LandChannel;
import com.bxm.adsprod.third.constant.Constants;
import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.HeiNiuLandVo;
import com.bxm.adsprod.third.model.HeiNiuSubmitRsp;
import com.bxm.adsprod.third.model.LandUserInfo;
import com.bxm.adsprod.third.model.land.BaseLandUserParamsDto;
import com.bxm.adsprod.third.model.land.LandUserActionResultVo;
import com.bxm.adsprod.third.model.third.HeiNiuInfo;
import com.bxm.adsprod.third.service.core.LandUserOperationService;
import com.bxm.adsprod.third.util.MathUtil;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.*;

@Service
public class LandService extends BaseService implements InitializingBean {

    @Autowired
    private LandUserInfoMapper landUserInfoMapper;

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired(required = false)
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Value("${heiniu.domain}")
    private String heiNiuDomain;

    @Autowired
    @Qualifier("jedisFetcherForOld")
    private Fetcher jedisFetcherForOld;

    @Autowired
    private List<LandUserOperationService> landUserOperationServices;
    private static Map<String, LandUserOperationService> landUserOperationServiceMap;

    @Override
    public void afterPropertiesSet() throws Exception {
        // 初始化
        landUserOperationServiceMap = new HashMap<>(landUserOperationServices.size());
        for (LandUserOperationService landUserAction : landUserOperationServices) {
            landUserOperationServiceMap.put(landUserAction.getActionCode(), landUserAction);
        }
    }


    public HeiNiuLandVo getHeiNiuLandInfo(String channel, String ip) throws ThirdException {
        HeiNiuLandVo rsp = new HeiNiuLandVo();
        rsp.setId(LandChannel.HEINIU.getChannel());
        Map<String, String> param = new HashMap<>(3);
        param.put("token", Constants.HEINIU_TOKEN);
        param.put("ip", ip);
        try {
            param.put("callback_url", URLEncoder.encode(Constants.HEINIU_LAND_CUSTOM_ACTIVITY_URL, "UTF-8"));
            Connection.Response response = Jsoup.connect(heiNiuDomain + Constants.HEINIU_LAND_SKIN_URL).data(param).ignoreContentType(true).method(Connection.Method.POST).execute();
            if(null != response){
                JSONObject jsonObject = JSONObject.parseObject(response.body());
                String policyCode = jsonObject.getString("policy_postfix");
                if(StringUtils.isBlank(policyCode)){
                    throw new ThirdException(ErrorCode.E0100005.getCode(), "黑牛素材接口响应为空");
                }
                rsp.setValidity(jsonObject.getString("policy_validity"));
                rsp.setPolicyCode(jsonObject.getString("policy_postfix"));
                rsp.setAgeRange(jsonObject.getString("policy_age_range"));
                rsp.setTitle(jsonObject.getString("policy_name"));
                rsp.setIsDdh(jsonObject.getBooleanValue("is_ddh"));
                List<HeiNiuInfo> infos = jsonObject.getJSONArray("policy_infos").toJavaList(HeiNiuInfo.class);
                rsp.setDetail(infos);
            }
        }catch (IOException e) {
            logger.error("LandService.getHeiNiuLandInfo request heiniu fail,reason={}", e);
            throw  new ThirdException(e);
        }
        return rsp;
    }

    public boolean smsVerifyCode(String channel, String userPhone, String ip) throws ThirdException {
        //1.短信发送频次校验-同一个手机号，一天只能发送3次，每次间隔60s以上；
        KeyGenerator keyGenerator = ActivityKeyGenerator.User.getUserSmsRecord(userPhone);
        Map<String, String> cache = fetcher.hfetchall(keyGenerator, String.class);
        TreeMap<String, String> map;
        long now = System.currentTimeMillis();
        if (MapUtils.isEmpty(cache)) {
            map = new TreeMap<>();
        } else {
            map = new TreeMap(cache);
            int size = map.size();
            long s = now;
            //获取最后一次发送验证码的时间
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                s = Long.parseLong(iterator.next());
            }
            if ((now - s) <= 60000) {
                throw new ThirdException(ErrorCode.E0100001);
            }
            if (size >= 3) {
                throw new ThirdException(ErrorCode.E0100002);
            }
        }

        //调用黑牛发送短信
        String code = MathUtil.createRandom(6);
        if(LandChannel.HEINIU.getChannel().equals(channel)){

            Map<String, String> param = new HashMap<>(4);
            param.put("token", Constants.HEINIU_TOKEN);
            param.put("ip", ip);
            param.put("mobile", userPhone);
            param.put("captcha", code);
            try {
                Connection.Response response = Jsoup.connect(heiNiuDomain + Constants.HEINIU_LAND_SMS_URL).data(param).ignoreContentType(true).method(Connection.Method.POST).execute();
                if(null != response){
                    JSONObject jsonObject = JSONObject.parseObject(response.body());
                    String errorCode = jsonObject.getString("error_code");
                    if(StringUtils.equals("0",errorCode)){
                        throw new ThirdException(ErrorCode.E0100005.getCode(), jsonObject.getString("error_msg"));
                    }
                }
            }catch (Exception e){
                logger.error("LandService.smsVerifyCode request heiniu fail,reason={}", e);
                throw new ThirdException(e);
            }
        }
        map.put(String.valueOf(now), code);
        //第一次请求时候设置24小时过期时间
        updater.hmupdate(keyGenerator, map, map.size() == 1 ? 86400 : 0);
        return true;
    }

    public HeiNiuSubmitRsp submit(LandUserInfo landUserInfo, String ip, String ua) throws ThirdException {
        //校验验证码是否正确以及是否过期（120s）
        verifyCode(landUserInfo);

        //用户信息保存到表tbl_land_user_info
        saveUserInfo(landUserInfo);

        HeiNiuSubmitRsp rsp = new HeiNiuSubmitRsp();
        Map<String, String> param = new HashMap<>(7);
        param.put("token", Constants.HEINIU_TOKEN);
        param.put("ip", ip);
        param.put("id_card", landUserInfo.getIdentification());
        param.put("name", landUserInfo.getUserName());
        param.put("mobile", landUserInfo.getUserPhone());
        param.put("policy_code", landUserInfo.getPolicyCode());
        param.put("user_agent", ua);
        try {
            Connection.Response response = Jsoup.connect(heiNiuDomain + Constants.HEINIU_LAND_SUBMIT_URL).data(param).ignoreContentType(true).method(Connection.Method.POST).execute();
            if(null != response){
                JSONObject jsonObject = JSONObject.parseObject(response.body());
                String callbackUrl = jsonObject.getString("callback_url");
                if(StringUtils.isBlank(callbackUrl)){
                    throw new ThirdException(ErrorCode.E0100005.getCode(), "黑牛提交接口响应为空");
                }
                rsp.setCallbackUrl(callbackUrl);
                rsp.setCouponUrl(jsonObject.getString("coupon_url"));
            }
        }catch (Exception e){
            logger.error("LandService.submit request heiniu fail,reason={}", e);
            throw new ThirdException(e);
        }
        return rsp;
    }

    /**
     * 提交用户信息时校验验证码
     * @param landUserInfo
     * @throws ThirdException
     */
    private void verifyCode(LandUserInfo landUserInfo) throws ThirdException {
        KeyGenerator keyGenerator = ActivityKeyGenerator.User.getUserSmsRecord(landUserInfo.getUserPhone());
        Map<String, String> cache = fetcher.hfetchall(keyGenerator, String.class);
        if (MapUtils.isEmpty(cache)) {
            //验证码不存在
            throw new ThirdException(ErrorCode.E0100004);
        }
        TreeMap<String, String> map = new TreeMap(cache);
        //获取最后一次发送验证码的记录
        Map.Entry<String, String> last = null;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        long now = System.currentTimeMillis();
        if (!last.getValue().equals(landUserInfo.getVerifyCode())) {
            //验证码错误
            throw new ThirdException(ErrorCode.E0100003);
        }
        if ((now - Long.valueOf(last.getKey())) >= 300000) {
            //验证码已超过120s未使用
            throw new ThirdException(ErrorCode.E0100004);
        }
    }

    private void saveUserInfo(LandUserInfo landUserInfo) {
        try {
            String result = jedisFetcherForOld.fetchWithSelector(() -> KeyBuilder.build("clickMsg", landUserInfo.getOrderId()), String.class, 11);
            if(StringUtils.isBlank(result)){
                logger.error("黑牛落地页获取订单信息失败：result={},orderId={}",result, landUserInfo.getOrderId());
                return;
            }
            String[] results = result.split(":");
            if (results.length < 6) {
                logger.error("黑牛落地页获取订单信息不全：result={},orderId={}",results, landUserInfo.getOrderId());
                return;
            }
            LandUserInfoDO landUserInfoDO = new LandUserInfoDO();
            landUserInfoDO.setActivityId(Long.parseLong(results[3]));
            landUserInfoDO.setAppkey(results[1]);
            landUserInfoDO.setChannel(LandChannel.HEINIU.getChannel());
            landUserInfoDO.setIdentification(landUserInfo.getIdentification());
            landUserInfoDO.setOrderId(landUserInfo.getOrderId());
            landUserInfoDO.setUserName(landUserInfo.getUserName());
            landUserInfoDO.setUserPhone(landUserInfo.getUserPhone());
            landUserInfoDO.setTicketId(Long.parseLong(results[4]));
            landUserInfoDO.setUid(results[5]);
            landUserInfoDO.setBusiness(results[2]);
            landUserInfoMapper.save(landUserInfoDO);
        }catch (Exception e){
            logger.error("LandService.submit save userInfo fail,reason={}", e);
        }
    }

    public boolean setIpDefined(String ticketId){
        KeyGenerator keyGenerator = TicketKeyGenerator.Filter.getIpLibraryDefined();
        Set<String> items = fetcher.hfetch(keyGenerator, "1", Set.class);
        if (CollectionUtils.isEmpty(items)) {
            items = new HashSet<>();
        }
        items.add(ticketId);
        updater.hupdate(keyGenerator, "1", items);
        return true;
    }


    /***
     *
     * 下面是新增得 提交落地页用户信息得接口
     *
     *
     *
     */
    /**
     * Description: 提交落地页用户信息得接口
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/18 20:11
     */
    public LandUserActionResultVo submitInfo(BaseLandUserParamsDto baseLandUserParamsDto) throws ThirdException {
        LandUserOperationService landUserAction = landUserOperationServiceMap.get(baseLandUserParamsDto.getActionCode());
        if (null == landUserAction) {
            throw new ThirdException(ErrorCode.E9999999.getCode(), "未查询到处理类！");
        }
        logger.info("==============请求参数：" + baseLandUserParamsDto.getParamsJson());
        return landUserAction.doOperation(baseLandUserParamsDto);
    }

}
