package com.bxm.adsprod.third.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.common.utils.IpUtils;
import com.bxm.adsprod.dal.activity.AdTicketIpMapper;
import com.bxm.adsprod.dal.activity.LandInterfaceMapper;
import com.bxm.adsprod.dal.entity.AdTicketIpDO;
import com.bxm.adsprod.dal.entity.LandInterfaceDO;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.constant.LandChannel;
import com.bxm.adsprod.model.constant.UpdateType;
import com.bxm.adsprod.model.dto.AdTicketIpDto;
import com.bxm.adsprod.third.constant.Constants;
import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.third.HeiNiuIp;
import com.bxm.adsprod.third.model.third.HeiNiuResult;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;

@Service
public class ThirdService extends BaseService {
	@Autowired
	private AdTicketIpMapper adTicketIpMapper;

	@Autowired
	private LandInterfaceMapper landInterfaceMapper;

	@Autowired(required = false)
	@Qualifier("jedisUpdater")
	private Updater updater;

	@Autowired(required = false)
	@Qualifier("jedisFetcher")
	private Fetcher fetcher;

	@Value("${heiniu.domain}")
	private String heiNiuDomain;

	@Value("${click.domain}")
	private String clickDomain;

	@Autowired
	@Qualifier("jedisFetcherForOld")
	private Fetcher jedisFetcherForOld;

	public boolean updateIpLibrary(String channel, String urlStr, Integer updateType, Integer updateAll, String token) throws IOException, ThirdException {

		checkToken(token);
		int channelId = LandChannel.getLandChannel(channel).getId();
        // 2.根据channel选择对应更新ip库的渠道
		if (LandChannel.HEINIU.getChannel().equals(channel)) {

			// 获得网络连接
			if(StringUtils.isBlank(urlStr)){
				StringBuilder sb = new StringBuilder(heiNiuDomain);
				sb.append(Constants.HEINIU_LAND_UPDATE_IP_URL).append("?").append("token=").append(Constants.HEINIU_TOKEN);
				urlStr = sb.toString();
			}
			URL url = new URL(urlStr);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection(); // 设置超时间为3秒
			conn.setConnectTimeout(3 * 1000); // 防止屏蔽程序抓取而返回403错误
			Map<Integer, Integer> map;
			if (UpdateType.BY_TXT.getValue().equals(updateType)) {
				// 得到下载输入流,解析IP库每行数据,并进行初步排序
				map = sort4Txt(conn);
			} else if (UpdateType.BY_RESPONSE.getValue().equals(updateType)) {
				// 得到json格式响应,解析IP库每行数据,并进行初步排序
				map = sort4Json(conn);
			} else {
				return false;
			}


			// 去重,map2用来存放去重后的信息
			Map<Integer, Integer> map2 = quChong(map);

			//异步执行更新数据库操作
			UpdateIpTask task = new UpdateIpTask(channelId, updateAll, map2);
			task.run();

			return true;
		}

		return false;
	}

	/**
	 * 将响应中的json格式的ip库整理排序
	 * @param conn
	 * @return
	 * @throws IOException
	 */
	private Map<Integer, Integer> sort4Json(HttpURLConnection conn) throws IOException{
		StringBuffer sbf = new StringBuffer();
		BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
		String temp;
		while ((temp = reader.readLine()) != null) {
			sbf.append(temp);
			sbf.append("\r\n");
		}
		reader.close();

		JSONObject res = JSONObject.parseObject(sbf.toString());
		Map<Integer, Integer> map = new TreeMap<>();
		if(null != res){
			JSONArray ipRange = res.getJSONArray("ip_range");
			List<HeiNiuIp> ips = ipRange.toJavaList(HeiNiuIp.class);
			ips.forEach(e ->{
				int startIp = IpUtils.getIntIp(e.getS());
				int endIp = IpUtils.getIntIp(e.getE());
				if (startIp != 0 && endIp != 0 && startIp < endIp) {
					map.put(startIp, endIp);
				}
			});
		}

		return map;
	}


	/**
	 * 将响应中txt文本格式的ip库整理排序
	 * @param conn
	 * @return
	 * @throws IOException
	 */
	private Map<Integer, Integer> sort4Txt(HttpURLConnection conn) throws IOException {
		InputStream inputStream = conn.getInputStream();
		InputStreamReader inReader = new InputStreamReader(inputStream, "UTF-8");
		BufferedReader bufReader = new BufferedReader(inReader);

		String line;
		// 解析IP库每行数据并排序
		Map<Integer, Integer> map = new TreeMap<>();
		while ((line = bufReader.readLine()) != null) {
			String[] split = line.split("-");
			if (split.length == 2) {
				int startIp = IpUtils.getIntIp(split[0]);
				int endIp = IpUtils.getIntIp(split[1]);
				if (startIp != 0 && endIp != 0 && startIp < endIp) {
					map.put(startIp, endIp);
				}

			}
		}
		bufReader.close();
		inReader.close();
		return map;
	}

	/**
	 * 排序后ip库map去重
	 * @param map
	 * @return
	 */
	private Map<Integer, Integer> quChong(Map<Integer, Integer> map) {
		Integer startIp = null;
		Integer endIp = null;
		int i = 1;
		Map<Integer, Integer> map2 = new TreeMap<>();
		Iterator it = map.entrySet().iterator();
		Map.Entry<Integer, Integer> entry = null;
		while (it.hasNext()) {
			entry = (Entry<Integer, Integer>) it.next();
			Integer startIp2 = entry.getKey();
			Integer endIp2 = entry.getValue();
			if (i == 1) {
				map2.put(startIp2, endIp2);
				startIp = startIp2;
				endIp = endIp2;
			} else {
				if (startIp2.intValue() <= endIp.intValue()) {
					if (endIp2.intValue() >= endIp.intValue()) {
						map2.put(startIp, endIp2);
						endIp = endIp2;
					}
				} else {
					map2.put(startIp2, endIp2);
					startIp = startIp2;
					endIp = endIp2;
				}
			}
			i = 2;
		}
		return map2;
	}

	private void saveAndRefresh(int channelId, Map<Integer, Integer> map2, List<AdTicketIpDto> list) {
		Map.Entry<Integer, Integer> entry;
		// 写入数据库和reids缓存
		AdTicketIpDO ap = new AdTicketIpDO();

		Date nowDate = new Date();
		ap.setIpLibrary(channelId);
		ap.setCreateTime(nowDate);
		ap.setModifiedTime(nowDate);
		Iterator it2 = map2.entrySet().iterator();
		while (it2.hasNext()) {
			entry = (Entry<Integer, Integer>) it2.next();
			ap.setStartIp(entry.getKey());
			ap.setEndIp(entry.getValue());
			AdTicketIpDto adTicketIpDto = new AdTicketIpDto();
			BeanUtils.copyProperties(ap, adTicketIpDto);
			adTicketIpMapper.save(ap);
			System.out.println(adTicketIpDto);
			list.add(adTicketIpDto);
			logger.info("start={}, end={}", IpUtils.getStringIp(entry.getKey()),
					IpUtils.getStringIp(entry.getValue()));
		}

		// 刷新redis操作
		updater.hupdate(TicketKeyGenerator.Filter.getIpLibrary(), String.valueOf(channelId), list);
		logger.info("广告定向ip库刷新redis成功，channel={},ipLibrary={}", channelId, JSONObject.toJSONString(list));
	}

	public boolean heiNiuResult(HeiNiuResult result, HttpServletRequest request) throws ThirdException {
		checkToken(result.getToken());
		//记录真实点击
		if(HeiNiuResult.SUCCESS_SETTLE.equals(result.getIsSettle())){
			click(result.getBxmId());
		}
		String order = jedisFetcherForOld.fetchWithSelector(() -> KeyBuilder.build("clickMsg", result.getBxmId()), String.class, 11);
		if(StringUtils.isBlank(order)){
			logger.error("黑牛落地页bxmId错误：result={},orderId={}",result, result.getBxmId());
			throw new ThirdException(ErrorCode.E0000001.getCode(), "BXMID 错误");
		}
		String[] results = order.split(":");
		if (results.length < 6) {
			logger.error("黑牛落地页bxmId错误：result={},orderId={}",results, result.getBxmId());
			throw new ThirdException(ErrorCode.E0000001.getCode(), "BXMID 错误");
		}
		LandInterfaceDO landInterfaceDO = new LandInterfaceDO();
		landInterfaceDO.setAskDirection(2);
		landInterfaceDO.setChannel(LandChannel.HEINIU.getChannel());
		landInterfaceDO.setOrderId(result.getBxmId());
		landInterfaceDO.setUid(results[5]);
		landInterfaceDO.setUrl(request.getRequestURI());
		landInterfaceDO.setRequest(JSONObject.toJSONString(result));
		landInterfaceMapper.save(landInterfaceDO);

		return true;
	}

	private void click(String orderId){
		String url = clickDomain + "/shop/countInfo?bxm_id="+orderId+"&status=1&modeltype=7";
		try {
			Jsoup.connect(url).data().ignoreContentType(true).method(Connection.Method.GET).execute();
		}catch (Exception e){
			logger.error("记录黑牛落地页有效点击失败,url={}, cause={}",url, e);
		}
	}

	private void checkToken(String token) throws ThirdException {
		if(!StringUtils.equals(token, Constants.HEINIU_TOKEN)){
			throw new ThirdException(ErrorCode.E0100006);
		}
	}

	private class UpdateIpTask implements Runnable{

		private int channelId;

		private int updateAll;

		private Map<Integer, Integer> map;

		public UpdateIpTask(int channelId, int updateAll, Map<Integer, Integer> map) {
			this.channelId = channelId;
			this.updateAll = updateAll;
			this.map = map;
		}

		@Override
		public void run() {
			// 根据更新方式更新
			List<AdTicketIpDto> list = Lists.newArrayList();
			if (UpdateType.INCREMENTAL.getValue().equals(updateAll)) {
				list = fetcher.hfetchList(TicketKeyGenerator.Filter.getIpLibrary(), String.valueOf(channelId),
						AdTicketIpDto.class);
			} else if (UpdateType.FULL.getValue().equals(updateAll)) {
				adTicketIpMapper.deleteByChannelId(channelId);
			}

			// 同步数据库以及刷新redis
			saveAndRefresh(channelId, map, list);
		}

	}
}
