package com.bxm.adsprod.third.service.alipay;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayUserAccountDeviceInfoQueryRequest;
import com.alipay.api.request.AlipayUserSceneCooperationConsultRequest;
import com.alipay.api.response.AlipayUserAccountDeviceInfoQueryResponse;
import com.alipay.api.response.AlipayUserSceneCooperationConsultResponse;
import com.bxm.adsprod.dal.alipay.AlipayMobileMapper;
import com.bxm.adsprod.dal.entity.AlipayMobile;
import com.bxm.adsprod.third.constant.Constants;
import com.bxm.adsprod.third.constant.ConstantsAlipay;
import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.alipay.DeviceInfo;
import com.bxm.adsprod.third.service.BaseService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import sun.applet.Main;

import javax.xml.bind.SchemaOutputResolver;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;


@Service
public class AlipayService extends BaseService {
    private static Integer newUser = 10000; //新用户
    private static Integer oldUser = 10001; //老用户

    private static String errorPositionId = "123456789";
    //18845077194

    @Autowired
    private AlipayMobileMapper alipayMobileMapper;
    @Autowired
    @Qualifier("jedisFetcherForOld")
    protected Fetcher jedisFetcherForOld;

    public Integer checkMoblie(String mobile, String bxmId, String source) throws Exception {
        Integer returnCode = null;
        if (StringUtils.isBlank(mobile)) {
            return oldUser;
        }
        String pid = ConstantsAlipay.bxm_pid;
        String appId = ConstantsAlipay.bxm_appId;
        String privateKey = ConstantsAlipay.bxm_privateKey;
        String publicKey = ConstantsAlipay.bxm_publicKey;
        String encryption = ConstantsAlipay.bxm_encryption;
        String scene = ConstantsAlipay.bxm_scence;
        String parendId = ConstantsAlipay.bxm_parentId;
        //根据来源获取支付宝秘钥 ;1是变现猫  2 是一帆
        if (StringUtils.equalsIgnoreCase("2", source)) {
            pid = ConstantsAlipay.yf_pid;
            appId = ConstantsAlipay.yf_appId;
            privateKey = ConstantsAlipay.yf_privateKey;
            publicKey = ConstantsAlipay.yf_publicKey;
            encryption = ConstantsAlipay.yf_encryption;
            scene = ConstantsAlipay.yf_scence;
            parendId = ConstantsAlipay.yf_parentId;
        }

        //根据bxmId获取positionId,如果bxmId为空则是错误positionId
        String positionId = errorPositionId;
        if (StringUtils.isNotBlank(bxmId)) {
            String results = jedisFetcherForOld.fetchWithSelector(() -> KeyBuilder.build("clickMsg", bxmId), String.class, 11);
            if (StringUtils.isNotBlank(results)) {
                String[] resultsMsg = results.split(":");
                if (resultsMsg.length >= 6) {
                    positionId = buildPosition(resultsMsg[1], repairBusiness(resultsMsg[2]));
                }
            }
        }

        AlipayMobile alipayMobile = new AlipayMobile();
        alipayMobile.setMobile(mobile);
        alipayMobile.setPositionId(positionId);
        //默认不是支付宝新用户
        alipayMobile.setStatus((short) 1);
        AlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, privateKey,
                "json", "GBK", publicKey, encryption);
        AlipayUserAccountDeviceInfoQueryRequest request = new AlipayUserAccountDeviceInfoQueryRequest();
        request.setBizContent("{" + "\"device_type\":\"MOBILE\"," + "      \"device_ids\":["
                + "        \"" + mobile + "\"" + "]," + "\"request_from\":\"" + scene + "\"," + "  }");
        AlipayUserAccountDeviceInfoQueryResponse response = alipayClient.execute(request);
        if (response.isSuccess()) {
            String responseBody = response.getBody();
            JSONObject json = JSONObject.parseObject(responseBody);
            String result = json.getString("alipay_user_account_device_info_query_response");
            JSONObject jsonresult = JSONObject.parseObject(result);
            String code = jsonresult.getString("code");
            String deviceInfos = jsonresult.getString("device_infos");
            if (StringUtils.equals("10000", code)) {
                if (StringUtils.isNotBlank(deviceInfos)) {
                    List<DeviceInfo> deviceInfo = JSONObject.parseArray(deviceInfos, DeviceInfo.class);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deviceInfo)) {
                        // 开始执行绑定接口
                        if (bingdingAliPay(alipayClient, mobile, scene, pid, parendId)) {
                            //是支付宝新用户
                            alipayMobile.setStatus((short) 0);
                            returnCode = newUser;
                        } else {
                            returnCode = oldUser;
                        }
                    } else {
                        returnCode = oldUser;
                    }
                } else {
                    returnCode = oldUser;
                }
            }
        }
        //插入数据库，报错也不影响
        try {
            Long id = alipayMobileMapper.getAlipayMobileByParams(alipayMobile);
            if (id == null) {
                alipayMobileMapper.insertSelective(alipayMobile);
            } else {
                alipayMobile.setId(id);
                alipayMobile.setModifyTime(new Date());
                alipayMobileMapper.updateByPrimaryKeySelective(alipayMobile);
            }
        } catch (Exception e) {
        }
        return returnCode;
    }

    public static Boolean bingdingAliPay(AlipayClient alipayClient, String mobile, String scene, String pid, String parendId) throws AlipayApiException {
        AlipayUserSceneCooperationConsultRequest request = new AlipayUserSceneCooperationConsultRequest();
        request.setBizContent("{" + "\"principal\":{" + "\"mobile\":\"" + mobile + "\"   }," + "\"scene\":\"" + scene
                + "\"," + "\"invite_scene\":\"CommerceService\"," + "\"pid\":\"" + pid + "\","
                + "\"partner_id\":\""+parendId+"\""
                + "  }");
        AlipayUserSceneCooperationConsultResponse response = alipayClient.execute(request);
        if (response.isSuccess()) {
            JSONObject json = JSONObject.parseObject(response.getBody());
            String result = json.getString("alipay_user_scene_cooperation_consult_response");
            JSONObject jsonresult = JSONObject.parseObject(result);
            String code = jsonresult.getString("code");
            String consult_result = jsonresult.getString("consult_result");
            String invite_result = jsonresult.getString("invite_result");
            if (StringUtils.equals("10000", code)) {
                if (consult_result.equals("true") && invite_result.equals("true")) {
                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private String repairBusiness(String business) {
        return business.replace("ad-", "").replace("money-", "");
    }

    private String buildPosition(String appkey, String business) {
        return StringUtils.join(new String[]{appkey, business}, '-');
    }

}
