package com.bxm.adsprod.third.service.core;

import com.bxm.adsprod.dal.activity.LandUserInfoMapper;
import com.bxm.adsprod.dal.entity.LandUserInfoDO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/17 17:59
 * 修 改 人：
 * 日 期：
 * 描 述：
 * 版 本 号： v1
 */
@Component
public abstract class AbstractLandUserService implements LandUserOperationService {

    protected Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private LandUserInfoMapper landUserInfoMapper;

    @Autowired
    @Qualifier("jedisFetcher")
    protected Fetcher fetcher;

    @Autowired(required = false)
    @Qualifier("jedisUpdater")
    protected Updater updater;

    @Autowired
    @Qualifier("jedisFetcherForOld")
    protected Fetcher jedisFetcherForOld;


    /**
     * Description: 入库
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/17 19:21
     */
    protected Integer insertLandUserInfo(LandUserInfoDO landUserInfo){
        return landUserInfoMapper.save(landUserInfo);
    }
}
