package com.bxm.adsprod.third.service.core.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.bxm.adsprod.dal.entity.LandUserInfoDO;
import com.bxm.adsprod.model.constant.LandChannel;
import com.bxm.adsprod.third.constant.Constants;
import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.LandUserExInfoDto;
import com.bxm.adsprod.third.model.land.BaseLandUserParamsDto;
import com.bxm.adsprod.third.model.land.LandUserActionResultVo;
import com.bxm.adsprod.third.model.land.TencentNewsLandUserDto;
import com.bxm.adsprod.third.service.core.AbstractLandUserService;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/17 19:16
 * 修 改 人：
 * 日 期：
 * 描 述：
 * 版 本 号： v1
 */
@Component
public class TencentNewsLandUserServiceImpl extends AbstractLandUserService {

    @Override
    public LandUserActionResultVo doOperation(BaseLandUserParamsDto baseLandUserParamsDto) throws ThirdException {
        TencentNewsLandUserDto tencentNewsLandUserDto;
        try {
            tencentNewsLandUserDto = JSON.parseObject(baseLandUserParamsDto.getParamsJson(), TencentNewsLandUserDto.class);
        } catch (JSONException j) {
            throw new ThirdException(ErrorCode.E0000001.getCode(), "提交参数解析错误！");
        }
        if (null == tencentNewsLandUserDto) {
            throw new ThirdException(ErrorCode.E0000001.getCode(), "参数不存在！");
        }
        if (StringUtils.isBlank(tencentNewsLandUserDto.getBxmId())) {
            throw new ThirdException(ErrorCode.E0000001.getCode(), "参数[bxmid]不存在！");
        }

        String result = jedisFetcherForOld.fetchWithSelector(() -> KeyBuilder.build("clickMsg", tencentNewsLandUserDto.getBxmId()), String.class, 11);

        if (StringUtils.isBlank(result)) {
            logger.error("落地页获取缓存内容失败：result={},bxmid={}", result, tencentNewsLandUserDto.getBxmId());
            throw new ThirdException(ErrorCode.E0000001.getCode(), "落地页获取缓存内容失败！");
        }
        String[] results = result.split(":");
        if (results.length < 6) {
            logger.error("落地页获取缓存内容不全：result={},orderId={}", results, tencentNewsLandUserDto.getBxmId());
            throw new ThirdException(ErrorCode.E0000001.getCode(), "落地页获取缓存内容不全！");
        }

        // 保存
        LandUserInfoDO landUserInfoDO = new LandUserInfoDO();
        landUserInfoDO.setActivityId(Long.parseLong(results[3]));
        landUserInfoDO.setChannel(LandChannel.WANGZHUAN.getChannel());
        landUserInfoDO.setAppkey(results[1]);
        landUserInfoDO.setOrderId(tencentNewsLandUserDto.getBxmId());
        landUserInfoDO.setTicketId(Long.parseLong(results[4]));
        landUserInfoDO.setUid(results[5]);
        landUserInfoDO.setBusiness(results[2]);
        landUserInfoDO.setUserAgeRange(tencentNewsLandUserDto.getAgeRange());

        /**
         * 扩展信息
         */
        LandUserExInfoDto landUserExInfoDto = new LandUserExInfoDto();
        landUserExInfoDto.setOccupation(tencentNewsLandUserDto.getOccupation());
        landUserInfoDO.setInfo(JSON.toJSONString(landUserExInfoDto));

        if (super.insertLandUserInfo(landUserInfoDO) <= 0) {
            throw new ThirdException(ErrorCode.E9999999.getCode(), "保存数据失败！");
        }
        return null;
    }

    @Override
    public String getActionCode() {
        return Constants.LandUserInfoActionCode.TENCENT_NEWS;
    }
}
