package com.bxm.adsprod.third.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bxm.adsprod.facade.ticket.DIYSiteInfo;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.third.model.DIYSiteLandPageInfo;
import com.bxm.adsprod.third.model.NumInfo;
import com.bxm.adsprod.third.service.DIYSiteLandPageService;
import com.bxm.warcar.cache.Fetcher;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DIYSiteLandPageServiceImpl implements DIYSiteLandPageService {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Override
    public DIYSiteLandPageInfo getByPageId(Long pageId) {
        DIYSiteLandPageInfo pageInfo = new DIYSiteLandPageInfo();
        DIYSiteInfo info = fetcher.hfetch(TicketKeyGenerator.DIYSite.getPageInfo(), pageId + "", DIYSiteInfo.class);
        if(null != info) {
            pageInfo.setType(info.getType());
            pageInfo.setContent(info.getContent());
            if (StringUtils.isNotEmpty(info.getNumInfos())) {
                List<NumInfo> numInfos = JSON.parseObject(info.getNumInfos(), new TypeReference<ArrayList<NumInfo>>() {
                });
                pageInfo.setNumInfos(numInfos);
            }
        }
        return pageInfo;
    }
}
