package com.bxm.adsprod.third.service.landpage.impl;

import com.bxm.adsprod.third.model.landpage.Auth;
import com.bxm.adsprod.third.service.landpage.AuthService;
import com.bxm.warcar.integration.pair.MutablePair;
import com.bxm.warcar.integration.pair.Value;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.base.Preconditions;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Set;

/**
 * @author allen
 * @since 1.0.0
 */
@Service
public class AuthServiceImpl implements AuthService {

    private final MutablePair pair;

    public AuthServiceImpl(MutablePair pair) {
        this.pair = pair;
    }

    @Override
    public void saveOrUpdate(Auth auth) {
        Preconditions.checkNotNull(auth);
        Preconditions.checkArgument(StringUtils.isNotBlank(auth.getToken()));
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(auth.getPageids()));
        String key = getKey(auth.getToken());
        pair.set(key, JsonHelper.convert(auth));
    }

    @Override
    public boolean hasPermission(String token, String pageId) {
        String key = getKey(token);
        Value value = pair.get(key);
        Auth auth = value.toObject(Auth.class);
        if (null == auth) {
            return false;
        }
        Set<String> pageids = auth.getPageids();
        return CollectionUtils.isNotEmpty(pageids) && pageids.contains(pageId);
    }

    private String getKey(String token) {
        return "adsprod-landpage:auth:" + token;
    }
}
