package com.bxm.adsprod.third.service.landpage.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.adsprod.third.model.landpage.PageConfig;
import com.bxm.adsprod.third.model.landpage.PageItem;
import com.bxm.adsprod.third.service.landpage.PageConfigService;
import com.bxm.warcar.integration.pair.MutablePair;
import com.bxm.warcar.integration.pair.Value;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * @author allen
 * @since 1.0.0
 */
@Service
public class PageConfigServiceImpl implements PageConfigService {

    private final MutablePair pair;

    public PageConfigServiceImpl(MutablePair pair) {
        this.pair = pair;
    }

    @Override
    public void saveOrUpdate(PageConfig pageConfig) {

        Preconditions.checkNotNull(pageConfig);
        Preconditions.checkArgument(StringUtils.isNotBlank(pageConfig.getPageId()));

        String key = getKey(pageConfig.getPageId());
        pair.set(key, JSONArray.toJSONString(pageConfig.getItems()));
    }

    @Override
    public PageConfig get(String pageId) {
        PageConfig config = new PageConfig();
        config.setPageId(pageId);

        if(StringUtils.isBlank(pageId)){
            return config;
        }

        Value value = pair.get(getKey(pageId));
        if(value == null){
            return config;
        }

        String s = value.toObject(String.class);
        List<PageItem> list = JSONArray.parseArray(s,PageItem.class);
        config.setItems(list);

        return config;
    }

    private String getKey(String pageId) {
        return "adsprod-landpage:pageId:" + pageId;
    }
}
