package com.bxm.adsprod.third.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Map.Entry;

import com.bxm.adsprod.common.utils.IpUtils;
import com.bxm.adsprod.dal.activity.AdTicketIpMapper;
import com.bxm.adsprod.dal.entity.AdTicketIpDO;

public class DownloadUtil {

	/** 
     * 从网络Url中下载文件 
     * @param urlStr 
     * @param fileName 
     * @param savePath 
     * @throws IOException 
     */  
    public static void  downLoadFromUrl(String urlStr,String fileName,String savePath) throws IOException{  
        URL url = new URL(urlStr);    
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();    
                //设置超时间为3秒  
        conn.setConnectTimeout(3*1000);  
        //防止屏蔽程序抓取而返回403错误  
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");  
  
        //得到输入流  
        InputStream inputStream = conn.getInputStream();    
        //获取自己数组  
        byte[] getData = readInputStream(inputStream);      
  
        //文件保存位置  
        File saveDir = new File(savePath);  
        if(!saveDir.exists()){  
            saveDir.mkdir();  
        }  
        File file = new File(saveDir+File.separator+fileName);      
        FileOutputStream fos = new FileOutputStream(file);       
        fos.write(getData);   
        if(fos!=null){  
            fos.close();    
        }  
        if(inputStream!=null){  
            inputStream.close();  
        }  
  
  
        System.out.println("info:"+url+" download success");   
  
    }  

    /** 
     * 从输入流中获取字节数组 
     * @param inputStream 
     * @return 
     * @throws IOException 
     */  
    public static  byte[] readInputStream(InputStream inputStream) throws IOException {    
        byte[] buffer = new byte[1024];    
        int len = 0;    
        ByteArrayOutputStream bos = new ByteArrayOutputStream();    
        while((len = inputStream.read(buffer)) != -1) {    
            bos.write(buffer, 0, len);    
        }    
        bos.close();    
        return bos.toByteArray();    
    }    
    
    public static void  read( AdTicketIpMapper adTicketIpMapper) throws IOException {
    	
		String savePath = "E:\\bigdata2";
		String fileName="heiniu.txt";
		InputStreamReader inReader = new InputStreamReader(new FileInputStream(savePath+File.separator+fileName), "UTF-8");
		BufferedReader bufReader = new BufferedReader(inReader);
		String line = null;
		// 解析IP库每行数据并排序
		Map<Integer, Integer> map = new TreeMap<>();
		while ((line = bufReader.readLine()) != null) {
			String[] split = line.split("-");
		if (split.length==2) {
         	int startIp = IpUtils.getIntIp(split[0]);
			int endIp = IpUtils.getIntIp(split[1]);
		if (startIp!=0&&endIp!=0&&startIp<endIp) {
				map.put(startIp, endIp);
			}
			
		}}
		bufReader.close();
		inReader.close();
		
	
		
		Integer startIp =0;
		Integer endIp = 0;

		// 去重,删除重复的IP段
		AdTicketIpDO ap= new AdTicketIpDO();
		Iterator it = map.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry<Integer, Integer>	entry = (Entry<Integer, Integer>) it.next();
			Integer startIp2 = entry.getKey();
			Integer endIp2 = entry.getValue();
			ap.setIpLibrary(1);
			Date nowDate=new Date();
			ap.setCreateTime(nowDate);
			ap.setModifiedTime(nowDate);
			if (startIp2 <= endIp) {
				ap.setStartIp(startIp);
				ap.setEndIp(endIp2);

		     	adTicketIpMapper.updateById(ap);
			} else {
				ap.setStartIp(startIp2);
				ap.setEndIp(endIp2);
			
				adTicketIpMapper.save(ap);
				System.out.println(startIp2+""+endIp2);
				startIp = startIp2;
			}
			endIp = endIp2;
		}
    	
    	
    }
}
