package com.bxm.adsprod.third.util;

import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;


public class IpUtils {

    /**
     * 获取客户端IP
     *
     * @author fhy
     * @created 2016-7-13 下午9:09:13
     */
    public static String getRemoteIp(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) == false && ("unknown".equalsIgnoreCase(ip) == false)) {
            final int i = ip.indexOf(',');
            return (i == -1) ? ip : ip.substring(0, i);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }


}
