/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.service.core.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.bxm.adsprod.dal.entity.LandUserInfoDO;
import com.bxm.adsprod.model.constant.LandChannel;
import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.LandUserExInfoDto;
import com.bxm.adsprod.third.model.land.BaseLandUserParamsDto;
import com.bxm.adsprod.third.model.land.LandUserActionResultVo;
import com.bxm.adsprod.third.model.land.TencentNewsLandUserDto;
import com.bxm.adsprod.third.service.core.AbstractLandUserService;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TencentNewsLandUserServiceImpl
extends AbstractLandUserService {
    @Override
    public LandUserActionResultVo doOperation(BaseLandUserParamsDto baseLandUserParamsDto) throws ThirdException {
        TencentNewsLandUserDto tencentNewsLandUserDto;
        try {
            tencentNewsLandUserDto = (TencentNewsLandUserDto)JSON.parseObject((String)baseLandUserParamsDto.getParamsJson(), TencentNewsLandUserDto.class);
        }
        catch (JSONException j) {
            throw new ThirdException(ErrorCode.E0000001.getCode(), "\u63d0\u4ea4\u53c2\u6570\u89e3\u6790\u9519\u8bef\uff01");
        }
        if (null == tencentNewsLandUserDto) {
            throw new ThirdException(ErrorCode.E0000001.getCode(), "\u53c2\u6570\u4e0d\u5b58\u5728\uff01");
        }
        if (StringUtils.isBlank((String)tencentNewsLandUserDto.getBxmId())) {
            throw new ThirdException(ErrorCode.E0000001.getCode(), "\u53c2\u6570[bxmid]\u4e0d\u5b58\u5728\uff01");
        }
        String result = (String)this.jedisFetcherForOld.fetchWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"clickMsg", tencentNewsLandUserDto.getBxmId()}), String.class, 11);
        if (StringUtils.isBlank((String)result)) {
            this.logger.error("\u843d\u5730\u9875\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u5931\u8d25\uff1aresult={},bxmid={}", (Object)result, (Object)tencentNewsLandUserDto.getBxmId());
            throw new ThirdException(ErrorCode.E0000001.getCode(), "\u843d\u5730\u9875\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u5931\u8d25\uff01");
        }
        String[] results = result.split(":");
        if (results.length < 6) {
            this.logger.error("\u843d\u5730\u9875\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u4e0d\u5168\uff1aresult={},orderId={}", (Object)results, (Object)tencentNewsLandUserDto.getBxmId());
            throw new ThirdException(ErrorCode.E0000001.getCode(), "\u843d\u5730\u9875\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u4e0d\u5168\uff01");
        }
        LandUserInfoDO landUserInfoDO = new LandUserInfoDO();
        landUserInfoDO.setActivityId(Long.valueOf(Long.parseLong(results[3])));
        landUserInfoDO.setChannel(LandChannel.WANGZHUAN.getChannel());
        landUserInfoDO.setAppkey(results[1]);
        landUserInfoDO.setOrderId(tencentNewsLandUserDto.getBxmId());
        landUserInfoDO.setTicketId(Long.valueOf(Long.parseLong(results[4])));
        landUserInfoDO.setUid(results[5]);
        landUserInfoDO.setBusiness(results[2]);
        landUserInfoDO.setUserAgeRange(tencentNewsLandUserDto.getAgeRange());
        LandUserExInfoDto landUserExInfoDto = new LandUserExInfoDto();
        landUserExInfoDto.setOccupation(tencentNewsLandUserDto.getOccupation());
        landUserInfoDO.setInfo(JSON.toJSONString((Object)landUserExInfoDto));
        if (super.insertLandUserInfo(landUserInfoDO) <= 0) {
            throw new ThirdException(ErrorCode.E9999999.getCode(), "\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff01");
        }
        return null;
    }

    @Override
    public String getActionCode() {
        return "TENCENT_NEWS";
    }
}

