/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.service.landpage.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.adsprod.third.model.landpage.PageConfig;
import com.bxm.adsprod.third.model.landpage.PageItem;
import com.bxm.adsprod.third.service.landpage.PageConfigService;
import com.bxm.warcar.integration.pair.MutablePair;
import com.bxm.warcar.integration.pair.Value;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PageConfigServiceImpl
implements PageConfigService {
    private final MutablePair pair;

    public PageConfigServiceImpl(MutablePair pair) {
        this.pair = pair;
    }

    @Override
    public void saveOrUpdate(PageConfig pageConfig) {
        Preconditions.checkNotNull((Object)pageConfig);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pageConfig.getPageId()));
        String key = this.getKey(pageConfig.getPageId());
        this.pair.set(key, JSONArray.toJSONString(pageConfig.getItems()));
    }

    @Override
    public PageConfig get(String pageId) {
        PageConfig config = new PageConfig();
        config.setPageId(pageId);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return config;
        }
        Value value = this.pair.get(this.getKey(pageId));
        if (value == null) {
            return config;
        }
        String s = (String)value.toObject(String.class);
        List list = JSONArray.parseArray((String)s, PageItem.class);
        config.setItems(list);
        return config;
    }

    private String getKey(String pageId) {
        return "adsprod-landpage:pageId:" + pageId;
    }
}

